/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel.builder.complete;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.OperationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.CompleteConnectorModelBuilderValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class PagedOperationsOperationMustDeclareResponseBodyRule
extends CompleteConnectorModelBuilderValidationRule {
    public PagedOperationsOperationMustDeclareResponseBodyRule() {
        super("Paged Operations must declare a response body.", "All paged operations must declare an output type.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(ConnectorModelBuilder connectorModelBuilder) {
        return connectorModelBuilder.getOperationBuilders().stream().filter(op -> op.isIgnored() == null || op.isIgnored() == false).filter(op -> !this.skippedOutputTypeValidation((OperationBuilder)op, connectorModelBuilder)).filter(OperationBuilder::hasPagination).filter(op -> !this.hasOutputTypeDefinition((OperationBuilder)op)).map(this::getValidationError).collect(Collectors.toList());
    }

    private boolean hasOutputTypeDefinition(OperationBuilder operationBuilder) {
        if (operationBuilder.hasForcedOutputTypeSchema()) {
            return true;
        }
        return operationBuilder.getOutputMetadataBuilders().values().stream().anyMatch(x -> !x.isEmpty());
    }

    private boolean skippedOutputTypeValidation(OperationBuilder operationBuilder, ConnectorModelBuilder connectorModelBuilder) {
        Boolean skipped = (Boolean)ObjectUtils.defaultIfNull((Object)operationBuilder.getSkipOutputTypeValidation(), (Object)connectorModelBuilder.getSkipOutputTypeValidation());
        return skipped != null && skipped != false;
    }

    private ValidationResult getValidationError(OperationBuilder operationBuilder) {
        return new ValidationResult(this, "");
    }
}

