/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.DataWeaveExpressionParser;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.BaseParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ConnectorModelValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class AbstractEnricherArgumentsOptionalityValidationRule
extends ConnectorModelValidationRule {
    protected static final String PARAMETERS = "parameters";
    protected static final String QUERY_PARAMETERS = "queryParameters";
    protected static final String URI_PARAMETERS = "uriParameters";
    protected static final String HEADERS = "headers";

    public AbstractEnricherArgumentsOptionalityValidationRule(String enricherType) {
        super(String.format("When sending an argument to a %s if the value expression is based on non required parameters the resolver may not be invoked", enricherType), "", ValidationRule.Level.WARN);
    }

    protected void validateParameters(List<ValidationResult> validationResults, ConnectorOperation connectorOperation, Map<String, Object> context, List<Argument> arguments) {
        if (connectorOperation.getParameters().isPresent()) {
            this.doValidation(validationResults, connectorOperation, arguments, ((List)connectorOperation.getParameters().get()).stream().collect(Collectors.toList()), PARAMETERS, context);
        }
        this.doValidation(validationResults, connectorOperation, arguments, connectorOperation.getQueryParameters().stream().map(declaredParameters -> declaredParameters).collect(Collectors.toList()), QUERY_PARAMETERS, context);
        this.doValidation(validationResults, connectorOperation, arguments, connectorOperation.getUriParameters().stream().map(declaredParameters -> declaredParameters).collect(Collectors.toList()), URI_PARAMETERS, context);
        this.doValidation(validationResults, connectorOperation, arguments, connectorOperation.getHeaders().stream().map(declaredParameters -> declaredParameters).collect(Collectors.toList()), HEADERS, context);
    }

    private void doValidation(List<ValidationResult> validationResults, ConnectorOperation connectorOperation, List<Argument> arguments, List<BaseParameter> parameters, String variableName, Map<String, Object> context) {
        for (Argument argument : arguments) {
            String[] referencedParameters = DataWeaveExpressionParser.selectionsFromBinding((String)argument.getValue().getValue(), (String)variableName);
            for (int i = 0; i < referencedParameters.length; ++i) {
                String referencedParameter = referencedParameters[i];
                parameters.stream().filter(parameter -> parameter.getExternalName().equals(referencedParameter)).filter(parameter -> parameter.isRequired() == false).filter(parameter -> parameter instanceof Parameter && RestSdkUtils.isBlank((CharSequence)((Parameter)parameter).getDefaultValue()) || !(parameter instanceof Parameter)).findFirst().map(parameter -> validationResults.add(this.getValidationError(connectorOperation, argument, variableName, (BaseParameter)parameter, context)));
            }
        }
    }

    protected abstract ValidationResult getValidationError(ConnectorOperation var1, Argument var2, String var3, BaseParameter var4, Map<String, Object> var5);
}

