/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DescriptorAdditionalParameterMustNotBePresentInApiRule
extends DescriptorValidationRule {
    public DescriptorAdditionalParameterMustNotBePresentInApiRule() {
        super("Operation additional parameters declared in the connector descriptor must not be present in the API spec", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        for (EndPointDescriptor endPointDescriptor : connectorDescriptor.getEndpoints()) {
            for (OperationDescriptor operationDescriptor : endPointDescriptor.getOperations()) {
                if (operationDescriptor.getExpects() == null) continue;
                results.addAll(this.validateParametersExists(operationDescriptor.getExpects().getUriParameter(), ParameterType.URI, endPointDescriptor.getPath(), operationDescriptor.getMethod(), apiModel));
                results.addAll(this.validateParametersExists(operationDescriptor.getExpects().getQueryParameter(), ParameterType.QUERY, endPointDescriptor.getPath(), operationDescriptor.getMethod(), apiModel));
                results.addAll(this.validateParametersExists(operationDescriptor.getExpects().getHeader(), ParameterType.HEADER, endPointDescriptor.getPath(), operationDescriptor.getMethod(), apiModel));
            }
        }
        return results;
    }

    private List<ValidationResult> validateParametersExists(List<ParameterDescriptor> parameters, ParameterType parameterType, String path, String method, APIModel apiModel) {
        return parameters.stream().filter(ParameterDescriptor::isAdditional).map(paramDesc -> this.validateParameterNotExists((ParameterDescriptor)paramDesc, parameterType, path, method, apiModel)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private ValidationResult validateParameterNotExists(ParameterDescriptor parameter, ParameterType parameterType, String path, String method, APIModel apiModel) {
        return apiModel.findOperation(path, method).map(x -> this.validateParameterExists((APIOperationModel)x, parameter, parameterType)).orElse(null);
    }

    private ValidationResult validateParameterExists(APIOperationModel apiOperation, ParameterDescriptor parameter, ParameterType parameterType) {
        return apiOperation.getParameter(parameterType.getApiParameterType(), parameter.getParamName()).isPresent() ? this.getValidationError(apiOperation, parameter, parameterType) : null;
    }

    private ValidationResult getValidationError(APIOperationModel apiOperationModel, ParameterDescriptor paramDescriptor, ParameterType parameterType) {
        String detail = String.format("Descriptor declares additional %s '%s' that exists in the API spec for path '%s', method '%s'", parameterType.getName(), paramDescriptor.getParamName(), apiOperationModel.getPath(), apiOperationModel.getHttpMethod().toUpperCase());
        return new ValidationResult(this, detail, paramDescriptor.getLocation());
    }
}

