/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APITypeModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DescriptorOtputMediaTypeMustBePresentInApiRule
extends DescriptorValidationRule {
    public DescriptorOtputMediaTypeMustBePresentInApiRule() {
        super("The output media type defined in the descriptor is not present in the API spec", "If the API spec defines a set of output media types for an operation the Descriptor must use one of those to define the operation's default output media type.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> allErrors = new ArrayList<ValidationResult>();
        for (EndPointDescriptor endpointDesc : connectorDescriptor.getEndpoints()) {
            List errors = endpointDesc.getOperations().stream().filter(opDesc -> StringUtils.isNotBlank((CharSequence)opDesc.getOutputMediaType())).filter(opDesc -> this.apiDefinesMediaTypes(apiModel, endpointDesc.getPath(), (OperationDescriptor)opDesc)).filter(opDesc -> !this.mediaTypePresentInApi(apiModel, endpointDesc.getPath(), (OperationDescriptor)opDesc)).map(opDesc -> this.getValidationErrorForOperationDescriptor(endpointDesc.getPath(), (OperationDescriptor)opDesc)).collect(Collectors.toList());
            allErrors.addAll(errors);
        }
        String globalMediaType = connectorDescriptor.getDefaultOutputMediaType();
        if (StringUtils.isNotBlank((CharSequence)globalMediaType)) {
            List globalErrors = apiModel.getOperationsModel().stream().filter(apiOp -> !apiOp.getOutputMetadataModel().isEmpty()).filter(apiOp -> apiOp.getOutputMetadataModel().stream().anyMatch(y -> y.getMediaType() != null)).filter(apiOp -> !this.descriptorDefinesMediaType(connectorDescriptor, (APIOperationModel)apiOp)).filter(apiOp -> !this.descriptorDefinesOperationMediaType(globalMediaType, (APIOperationModel)apiOp)).map(apiOp -> this.getValidationErrorForGlobalDescriptor(apiOp.getPath(), apiOp.getHttpMethod(), globalMediaType, connectorDescriptor)).collect(Collectors.toList());
            allErrors.addAll(globalErrors);
        }
        return allErrors;
    }

    protected boolean descriptorDefinesOperationMediaType(String globalMediaType, APIOperationModel apiOperationModel) {
        return apiOperationModel.getOutputMetadataModel().stream().anyMatch(y -> y.getMediaType().toString().equalsIgnoreCase(globalMediaType));
    }

    private boolean descriptorDefinesMediaType(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperation) {
        OperationDescriptor operationDescriptor = ValidationUtils.getOperationDescriptor(connectorDescriptor, apiOperation);
        return operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getOutputMediaType());
    }

    private boolean mediaTypePresentInApi(APIModel apiModel, String path, OperationDescriptor operationDesc) {
        String outputMediaType = operationDesc.getOutputMediaType();
        String method = operationDesc.getMethod();
        return apiModel.findOperation(path, method).flatMap(x -> x.getOutputMetadataModel().stream().map(APITypeModel::getMediaType).filter(mt -> mt.toString().equalsIgnoreCase(outputMediaType)).findAny()).isPresent();
    }

    private boolean apiDefinesMediaTypes(APIModel apiModel, String path, OperationDescriptor operationDesc) {
        return apiModel.findOperation(path, operationDesc.getMethod()).filter(x -> !x.getOutputMetadataModel().isEmpty()).isPresent();
    }

    private ValidationResult getValidationErrorForOperationDescriptor(String path, OperationDescriptor operationDescriptor) {
        String location = "API Operation with PATH: " + path + " and METHOD: " + operationDescriptor.getMethod().toUpperCase() + " does not declare '" + operationDescriptor.getOutputMediaType() + "' output media type that is used in the Operation Descriptor";
        return new ValidationResult(this, location, operationDescriptor.getLocation());
    }

    private ValidationResult getValidationErrorForGlobalDescriptor(String path, String method, String mediaType, ConnectorDescriptor connectorDescriptor) {
        String location = "API Operation with PATH: " + path + " and METHOD: " + method + " does not declare '" + mediaType + "' output media type that is used as global output media type in the Connector Descriptor";
        return new ValidationResult(this, location, connectorDescriptor.getLocation());
    }
}

