/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.MavenGavDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import java.util.ArrayList;
import java.util.List;

public class GavArtifactIdMustBeValidRule
extends DescriptorValidationRule {
    public GavArtifactIdMustBeValidRule() {
        super("Descriptor connectorGav's artifactId must ve a valid Maven artifactId", "The artifactId defined in the connector descriptor for the connectorGav can contain lowercase letters and no strange symbols.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        String validArtifactId;
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        MavenGavDescriptor gav = connectorDescriptor.getConnectorGav();
        if (gav == null || gav.getArtifactId() == null) {
            return validationResults;
        }
        String artifactId = gav.getArtifactId();
        if (!artifactId.equalsIgnoreCase(validArtifactId = XmlUtils.removeMavenArtifactUnwantedCharacters((String)artifactId))) {
            validationResults.add(this.getValidationError(connectorDescriptor));
        }
        return validationResults;
    }

    private ValidationResult getValidationError(ConnectorDescriptor connectorDescriptor) {
        String detail = String.format("Artifact Id '%s' is not a valid Maven artifactId", connectorDescriptor.getConnectorGav().getArtifactId());
        return new ValidationResult(this, detail, connectorDescriptor.getConnectorGav().getLocation());
    }
}

