/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.DataWeaveExpressionParser;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ConnectorModelValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.MediaType;

public class OperationAdapterBodyBindingShouldDefineBoundaryOnMultipartFormDataRule
extends ConnectorModelValidationRule {
    public OperationAdapterBodyBindingShouldDefineBoundaryOnMultipartFormDataRule() {
        super("Body expression used in request binding for multipart endpoints should define the boundary parameter as part of the mime type declaration.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorModel connectorModel) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        List operations = connectorModel.getOperations();
        for (ConnectorOperation operation : operations) {
            Optional outputMediaType;
            Optional<ParameterBinding> bodyParameterBinding;
            Optional requestBindings = operation.getRequestBindings();
            if (!requestBindings.isPresent() || operation.getInputMetadata() == null || !operation.getInputMetadata().getMediaType().equals((Object)MediaType.MULTIPART_FORM_DATA_TYPE) || !(bodyParameterBinding = ((List)requestBindings.get()).stream().filter(parameterBinding -> parameterBinding.getParameterType().equals((Object)ParameterType.BODY)).findFirst()).isPresent() || !(outputMediaType = DataWeaveExpressionParser.getOutputMediaType((String)bodyParameterBinding.get().getExpression())).isPresent() || !((MediaType)outputMediaType.get()).isCompatible(MediaType.MULTIPART_FORM_DATA_TYPE) || ((MediaType)outputMediaType.get()).getParameters().containsKey("boundary")) continue;
            results.add(this.getValidationError(operation));
        }
        return results;
    }

    private ValidationResult getValidationError(ConnectorOperation connectorOperation) {
        String detail = String.format("Body expression binding defined in Operation [%s] has an expression which output is a multipart/form-data but it has to define the boundary parameter as part of output directive (e.g., output multipart/form-data boundary='__c2341').", connectorOperation.getOperationIdentifier());
        return new ValidationResult(this, detail, null);
    }
}

