/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.commons.api.dw.DWBindings;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.ComparisonUtil;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OverrideResolverDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OverridesParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OverridesRequestDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.common.ArgumentDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.dataexpressions.HttpRequestDataExpressionBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.AbstractCustomFieldRule;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class OperationCustomFieldBindingMustBeMetadataKeyRule
extends AbstractCustomFieldRule {
    public OperationCustomFieldBindingMustBeMetadataKeyRule() {
        super("Parameters used in a custom field binding expression must be Metadata Key");
    }

    @Override
    protected void validateOverrideResolver(OperationAdapterDescriptor operationAdapterDescriptor, OverrideResolverDescriptor overrideResolver, List<ValidationResult> results) {
        HttpRequestDataExpressionBindingDescriptor bindings = overrideResolver.getRequest().getBindings();
        if (bindings != null) {
            Map<String, List<String>> metadataKey = this.findMetadataKey(operationAdapterDescriptor);
            bindings.getQueryParameters().forEach(param -> this.validateBinding(operationAdapterDescriptor, (ArgumentDescriptor)param, metadataKey, results));
            bindings.getUriParameters().forEach(param -> this.validateBinding(operationAdapterDescriptor, (ArgumentDescriptor)param, metadataKey, results));
            bindings.getHeaders().forEach(param -> this.validateBinding(operationAdapterDescriptor, (ArgumentDescriptor)param, metadataKey, results));
        }
    }

    private void validateBinding(OperationAdapterDescriptor operationAdapterDescriptor, ArgumentDescriptor param, Map<String, List<String>> metadataKeys, List<ValidationResult> results) {
        Pair<String, String> parameterTypeAndName = this.findParameterTypeAndName(param.getValue().getExpression());
        if (parameterTypeAndName != null && !this.metadataKeyExists((String)parameterTypeAndName.getLeft(), (String)parameterTypeAndName.getRight(), metadataKeys)) {
            results.add(this.getValidationError(operationAdapterDescriptor, (String)parameterTypeAndName.getLeft(), (String)parameterTypeAndName.getRight(), param.getLocation()));
        }
    }

    private boolean metadataKeyExists(String parameterType, String parameterName, Map<String, List<String>> metadataKeys) {
        return metadataKeys.containsKey(parameterType) && metadataKeys.get(parameterType).stream().anyMatch(mk -> ComparisonUtil.externalNameParamsComparison((String)parameterName, (String)mk, (ParameterType)ParameterType.fromBinding((String)parameterType)));
    }

    private Pair<String, String> findParameterTypeAndName(String expression) {
        String parameterName;
        String parameterType = this.getParameterTypeReference(expression);
        if (parameterType == null) {
            return null;
        }
        if (parameterType.equals(DWBindings.REQUEST.getBinding())) {
            parameterType = this.getParameterReference(expression, Collections.emptyList());
            parameterName = this.getParameterReference(expression, Collections.singletonList(parameterType));
        } else {
            parameterName = this.getParameterReference(expression, Collections.emptyList());
        }
        return Pair.of((Object)BINDINGS_MAPPING.getOrDefault(parameterType, parameterType), (Object)parameterName);
    }

    private Map<String, List<String>> findMetadataKey(OperationAdapterDescriptor operationAdapterDescriptor) {
        if (operationAdapterDescriptor.getBaseEndpoint() == null || operationAdapterDescriptor.getBaseEndpoint().getOverrides() == null) {
            return Collections.emptyMap();
        }
        OverridesRequestDescriptor overrides = operationAdapterDescriptor.getBaseEndpoint().getOverrides();
        HashMap<String, List<String>> metadataKeys = new HashMap<String, List<String>>();
        metadataKeys.put(ParameterType.QUERY.getBinding(), this.findMetadataKey(overrides.getQueryParameter()));
        metadataKeys.put(ParameterType.URI.getBinding(), this.findMetadataKey(overrides.getUriParameter()));
        metadataKeys.put(ParameterType.HEADER.getBinding(), this.findMetadataKey(overrides.getHeader()));
        return metadataKeys;
    }

    private List<String> findMetadataKey(List<OverridesParameterDescriptor> parameters) {
        return parameters.stream().filter(param -> param.getMetadataKey() != null).map(OverridesParameterDescriptor::getParamName).collect(Collectors.toList());
    }

    private ValidationResult getValidationError(OperationAdapterDescriptor operationAdapterDescriptor, String parameterType, String parameterName, DescriptorElementLocation descriptorElementLocation) {
        String detail = "Operation with name '" + operationAdapterDescriptor.getOperationId() + "' declares a custom field resolver request with a binding that uses '" + parameterType + "' parameter '" + parameterName + "' that is not Metadata Key.";
        return new ValidationResult(this, detail, descriptorElementLocation);
    }
}

