/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.files;

import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.FilesValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInOverrideMustExistInGeneratedCodeRule
extends FilesValidationRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileInOverrideMustExistInGeneratedCodeRule.class);

    public FileInOverrideMustExistInGeneratedCodeRule() {
        super("File In Override folder must exist in generated code", "", ValidationRule.Level.WARN);
    }

    @Override
    public List<ValidationResult> validate(Path outputDir, RestSdkRunConfiguration runConfiguration) {
        if (!runConfiguration.regenerateMode()) {
            return Collections.emptyList();
        }
        try {
            Path overrideDir = outputDir.resolve(runConfiguration.getOverrideDir());
            if (overrideDir.toFile().exists()) {
                return Files.walk(overrideDir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(x -> !ValidationUtils.isRefinementFile(x)).filter(file -> !this.isValidOverrideFile((Path)file, outputDir, runConfiguration)).map(this::getValidationResult).collect(Collectors.toList());
            }
        }
        catch (IOException e) {
            String message = String.format("Failed to validate connector, message [%s]", e.getMessage());
            LOGGER.error(message, (Throwable)e);
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private ValidationResult getValidationResult(Path file) {
        String detail = String.format("File '%s' is not overriding a generated file.", file.toString());
        return new ValidationResult(this, detail, null);
    }

    private boolean isValidOverrideFile(Path file, Path outputDir, RestSdkRunConfiguration runConfiguration) {
        String fileRelativePath = outputDir.relativize(file).toString().replace(runConfiguration.getOverrideDir(), "");
        String generatedFile = outputDir.resolve(runConfiguration.getIgnoredDir()).toString().concat(fileRelativePath);
        return Files.exists(Paths.get(generatedFile, new String[0]), new LinkOption[0]);
    }
}

