/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.amazon.kinesis.api;

import java.util.List;
import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.Xml;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.semantics.connectivity.ConfiguresNtlmProxy;
import org.mule.sdk.api.annotation.semantics.connectivity.Host;
import org.mule.sdk.api.annotation.semantics.connectivity.NtlmDomain;
import org.mule.sdk.api.annotation.semantics.connectivity.Port;
import org.mule.sdk.api.annotation.semantics.security.Username;

@DisplayName(value="Proxy")
@Xml(prefix="proxy")
@ConfiguresNtlmProxy
public class ProxyConfiguration {
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Proxy host")
    @Summary(value="Host where the proxy requests will be sent.")
    @Host
    private String host;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Proxy port")
    @Summary(value="Port where the proxy requests will be sent.")
    @Port
    private int port;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional
    @DisplayName(value="Proxy username")
    @Summary(value="The username to authenticate against the proxy.")
    @Username
    private String username;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional
    @Password
    @DisplayName(value="Proxy password")
    @Summary(value="The password to authenticate against the proxy.")
    private String password;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional
    @NullSafe
    @DisplayName(value="Non proxied hosts")
    @Summary(value="A list of hosts against which the proxy should not be used.")
    private List<String> nonProxyHosts;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional
    @DisplayName(value="NTLM Domain")
    @Summary(value="The domain to authenticate against the proxy.")
    @NtlmDomain
    private String ntlmDomain;

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public List<String> getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public String getNtlmDomain() {
        return this.ntlmDomain;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyConfiguration that = (ProxyConfiguration)o;
        return this.port == that.port && Objects.equals(this.host, that.host) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.nonProxyHosts, that.nonProxyHosts) && Objects.equals(this.ntlmDomain, that.ntlmDomain);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.username, this.password, this.nonProxyHosts, this.ntlmDomain);
    }
}

