/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.amazon.kinesis.api;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class Role {
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="ARN")
    @Summary(value="The Amazon Resource Name (ARN) of the role to assume.")
    private String arn;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="External ID")
    @Summary(value="A unique identifier that might be required when you assume a role in another account. If the administrator of the account to which the role belongs provides an external ID, then provide that value in this field.")
    private String externalId;
    @Parameter
    @Optional(defaultValue="3600")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Duration")
    @Summary(value="The duration of the role session.")
    private int duration;
    @Parameter
    @Optional(defaultValue="SECONDS")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Duration Time Unit")
    @Summary(value="Time unit for the Duration value.")
    private TimeUnit durationTimeUnit;
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Referred policy ARNs")
    @Summary(value="The Amazon Resource Names (ARNs) of the IAM-managed policies to use as managed session policies. The policies must exist in the same account as the role.")
    private List<String> referredPolicyArns;
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Tags")
    @Summary(value="A list of session tags that you want to pass. Each session tag consists of a key name and an associated value.")
    private Map<String, String> tags;

    public Role() {
    }

    public Role(String arn, String externalId, Integer duration, TimeUnit durationTimeUnit, List<String> referredPolicyArns, Map<String, String> tags) {
        this.arn = arn;
        this.externalId = externalId;
        this.duration = duration;
        this.durationTimeUnit = durationTimeUnit;
        this.referredPolicyArns = referredPolicyArns;
        this.tags = tags;
    }

    public String getArn() {
        return this.arn;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public int getDuration() {
        return this.duration;
    }

    public TimeUnit getDurationTimeUnit() {
        return this.durationTimeUnit;
    }

    public List<String> getReferredPolicyArns() {
        return this.referredPolicyArns;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Role)) {
            return false;
        }
        Role that = (Role)o;
        return this.duration == that.duration && Objects.equals(this.arn, that.arn) && Objects.equals(this.externalId, that.externalId) && this.durationTimeUnit == that.durationTimeUnit && Objects.equals(this.referredPolicyArns, that.referredPolicyArns) && Objects.equals(this.tags, that.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.arn, this.externalId, this.duration, this.durationTimeUnit, this.referredPolicyArns, this.tags});
    }
}

