/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.amazon.kinesis.api;

import com.mulesoft.connector.amazon.kinesis.api.AbsolutePosition;
import com.mulesoft.connector.amazon.kinesis.api.StreamInitialPosition;
import java.time.LocalDateTime;
import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.ExclusiveOptionals;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@ExclusiveOptionals(isOneRequired=true)
public class ShardInitialPosition
extends StreamInitialPosition {
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="At Sequence Number")
    @Summary(value="The option ensures that listeners will listen from a specific sequence number.")
    String atSequenceNumber;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="After Sequence Number")
    @Summary(value="The option ensures that listeners will listen from the next higher specific sequence number.")
    String afterSequenceNumber;

    public ShardInitialPosition() {
    }

    public ShardInitialPosition(AbsolutePosition absolutePosition, LocalDateTime timestamp, String atSequenceNumber, String afterSequenceNumber) {
        super(absolutePosition, timestamp);
        this.atSequenceNumber = atSequenceNumber;
        this.afterSequenceNumber = afterSequenceNumber;
    }

    public String getAtSequenceNumber() {
        return this.atSequenceNumber;
    }

    public String getAfterSequenceNumber() {
        return this.afterSequenceNumber;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShardInitialPosition)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ShardInitialPosition that = (ShardInitialPosition)o;
        return Objects.equals(this.atSequenceNumber, that.atSequenceNumber) && Objects.equals(this.afterSequenceNumber, that.afterSequenceNumber);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.atSequenceNumber, this.afterSequenceNumber);
    }
}

