/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.amazon.kinesis.api;

import com.mulesoft.connector.amazon.kinesis.api.AbsolutePosition;
import java.time.LocalDateTime;
import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.ExclusiveOptionals;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@ExclusiveOptionals(isOneRequired=true)
public class StreamInitialPosition {
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Absolute Position")
    @Summary(value="Whether the listener listens from the latest data record or the oldest data record")
    AbsolutePosition absolutePosition;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Timestamp")
    @Summary(value="Date and time from which the listener listens.")
    private LocalDateTime timestamp;

    public StreamInitialPosition() {
    }

    public StreamInitialPosition(AbsolutePosition position, LocalDateTime timestamp) {
        this.absolutePosition = position;
        this.timestamp = timestamp;
    }

    public AbsolutePosition getAbsolutePosition() {
        return this.absolutePosition;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StreamInitialPosition)) {
            return false;
        }
        StreamInitialPosition that = (StreamInitialPosition)o;
        return this.absolutePosition == that.absolutePosition && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.absolutePosition, this.timestamp});
    }
}

