/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.amazon.kinesis.internal.config.parameter;

import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.util.DataUnit;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class AdvancedProducerParameters {
    @Parameter
    @Optional(defaultValue="true")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Aggregation Enabled")
    @Placement(tab="Advanced", order=1)
    @Summary(value="When set to true, this option packs multiple user data records into a single Amazon Kinesis data record.")
    private boolean aggregationEnabled;
    @Parameter
    @Optional(defaultValue="30")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Response Timeout")
    @Placement(tab="Advanced", order=2)
    @Summary(value="The maximum total time that can elapse between the start of an HTTP request and when the responses are received. If this time is exceeded, the request times out.")
    private int responseTimeout;
    @Parameter
    @Optional(defaultValue="SECONDS")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Request Timeout Unit")
    @Placement(tab="Advanced", order=3)
    @Summary(value="A time unit that qualifies the Response Timeout value.")
    private TimeUnit responseTimeoutUnit;
    @Parameter
    @Optional(defaultValue="100")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Record Max Buffered Time")
    @Placement(tab="Advanced", order=4)
    @Summary(value="Maximum amount of time that an Amazon Kinesis data record spends buffering before it is sent. Records can be sent earlier than this value, depending on other buffering limits.")
    private int recordMaxBufferedTime;
    @Parameter
    @Optional(defaultValue="MILLISECONDS")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Record Max Buffered Time Unit")
    @Placement(tab="Advanced", order=5)
    @Summary(value="A time unit that qualifies the Record Max Buffered Time value.")
    private TimeUnit recordMaxBufferedTimeUnit;
    @Parameter
    @Optional(defaultValue="4294967295")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Aggregation Max Count")
    @Placement(tab="Advanced", order=6)
    @Summary(value="Maximum number of items to pack into an aggregated Amazon Kinesis data record.")
    private long aggregationMaxCount;
    @Parameter
    @Optional(defaultValue="51200")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Aggregation Max Size")
    @Placement(tab="Advanced", order=7)
    @Summary(value="Maximum data size to pack into an aggregated Amazon Kinesis data record.")
    private int aggregationMaxSize;
    @Parameter
    @Optional(defaultValue="BYTE")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Aggregation Max Size Unit")
    @Placement(tab="Advanced", order=8)
    @Summary(value="A data unit that qualifies the Aggregation Max Size value.")
    private DataUnit aggregationMaxSizeUnit;
    @Parameter
    @Optional(defaultValue="500")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Collection Max Count")
    @Placement(tab="Advanced", order=9)
    @Summary(value="Maximum number of items to pack into a batch request.")
    private int collectionMaxCount;
    @Parameter
    @Optional(defaultValue="5242880")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Collection Max Size")
    @Placement(tab="Advanced", order=10)
    @Summary(value="Maximum amount of data to send with a Put Record operation.")
    private int collectionMaxSize;
    @Parameter
    @Optional(defaultValue="BYTE")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Collection Max Size Unit")
    @Placement(tab="Advanced", order=11)
    @Summary(value="A data unit that qualifies the Collection Max Size value.")
    private DataUnit collectionMaxSizeUnit;
    @Parameter
    @Optional(defaultValue="30")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Connection Timeout")
    @Placement(tab="Advanced", order=12)
    @Summary(value="The amount of time to wait when initially establishing the TCP connection between the connector and Amazon Kinesis server before throwing an exception if the connection fails.")
    private int connectionTimeout;
    @Parameter
    @Optional(defaultValue="SECONDS")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Connection Timeout Unit")
    @Placement(tab="Advanced", order=13)
    @Summary(value="The time unit for the Connection Timeout value.")
    private TimeUnit connectionTimeoutUnit;
    @Parameter
    @Optional(defaultValue="24")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Max Connections")
    @Placement(tab="Advanced", order=14)
    @Summary(value="Maximum number of connections to open to the backend. HTTP requests are sent in parallel over multiple connections. Setting this value too high can impact latency and consume additional resources without increasing throughput.")
    private int maxDaemonConnections;
    @Parameter
    @Optional(defaultValue="1")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Min Connections")
    @Placement(tab="Advanced", order=15)
    @Summary(value="Minimum number of connections to keep open to the backend. In most cases, there is no need to increase value.")
    private int minConnections;
    @Parameter
    @Optional(defaultValue="150")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Rate Limit")
    @Placement(tab="Advanced", order=16)
    @Summary(value="Limits the number of data records per second and number of bytes per second sent to a shard. This limit can reduce bandwidth and CPU cycle wastage from sending requests that will fail from throttling. The default value, 150%, enables a single producer instance to completely saturate the allowance for a shard. To reduce throttling errors rather than completely saturate the shard, consider reducing this setting.")
    private long rateLimit;
    @Parameter
    @Optional(defaultValue="30")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Record TTL")
    @Placement(tab="Advanced", order=17)
    @Summary(value="Time limit for data records to be put. Records that are not successfully put within this limit fail. When setting this value, take into consideration the fact that data records still incur network latency after they leave the Amazon Kinesis Producer Library (KPL).")
    private long recordTtl;
    @Parameter
    @Optional(defaultValue="SECONDS")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Record TTL Unit")
    @Placement(tab="Advanced", order=18)
    @Summary(value="The time unit for the Record TTL value.")
    private TimeUnit recordTtlUnit;
    @Parameter
    @Placement(tab="Advanced", order=19)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Thread Pool Size")
    @Optional(defaultValue="0")
    @Summary(value="Maximum number of threads with which to configure the native process thread pool. The default value, 0, enables the KPL process to choose the size of the thread pool.")
    private int threadPoolSize;

    public boolean isAggregationEnabled() {
        return this.aggregationEnabled;
    }

    public long getAggregationMaxCount() {
        return this.aggregationMaxCount;
    }

    public int getCollectionMaxCount() {
        return this.collectionMaxCount;
    }

    public int getMaxDaemonConnections() {
        return this.maxDaemonConnections;
    }

    public int getMinConnections() {
        return this.minConnections;
    }

    public long getRateLimit() {
        return this.rateLimit;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public int getAggregationMaxSizeInBytes() {
        return this.aggregationMaxSizeUnit.toBytes(this.aggregationMaxSize);
    }

    public int getCollectionMaxSizeInBytes() {
        return this.collectionMaxSizeUnit.toBytes(this.collectionMaxSize);
    }

    public long getConnectionTimeoutInMillis() {
        return this.connectionTimeoutUnit.toMillis(this.connectionTimeout);
    }

    public long getRecordTtlInMillis() {
        return this.recordTtlUnit.toMillis(this.recordTtl);
    }

    public long getResponseTimeoutInMillis() {
        return this.responseTimeoutUnit.toMillis(this.responseTimeout);
    }

    public long getRecordMaxBufferedTimeInMillis() {
        return this.recordMaxBufferedTimeUnit.toMillis(this.recordMaxBufferedTime);
    }
}

