/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.amazon.kinesis.internal.connection.adapter;

import com.mulesoft.connector.amazon.kinesis.internal.error.exception.KinesisRuntimeException;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedContentSubscriber
implements Subscriber<ByteBuffer> {
    private static final Logger logger = LoggerFactory.getLogger(BufferedContentSubscriber.class);
    private final AtomicReference<Subscription> subscription = new AtomicReference();
    private final CountDownLatch latch = new CountDownLatch(1);
    private ByteBuffer buffer = ByteBuffer.allocate(0);

    public void onSubscribe(Subscription newSubscription) {
        if (newSubscription == null) {
            throw new NullPointerException("Subscription MUST NOT be null.");
        }
        if (this.subscription.get() == null) {
            if (this.subscription.compareAndSet(null, newSubscription)) {
                newSubscription.request(Long.MAX_VALUE);
            } else {
                this.onSubscribe(newSubscription);
            }
        } else {
            try {
                newSubscription.cancel();
            }
            catch (Exception e) {
                logger.error("{} violated the Reactive Streams rule 3.15 by throwing an exception from cancel.", (Object)newSubscription);
            }
        }
    }

    public void onNext(ByteBuffer byteBuffer) {
        ByteBuffer newResponseBuffer = ByteBuffer.allocate(this.buffer.limit() + byteBuffer.limit());
        newResponseBuffer.put(this.buffer);
        newResponseBuffer.put(byteBuffer);
        this.buffer = newResponseBuffer;
    }

    public void onError(Throwable throwable) {
        this.latch.countDown();
    }

    public void onComplete() {
        this.latch.countDown();
    }

    public byte[] getContent() {
        try {
            this.latch.await();
            return this.buffer.array();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new KinesisRuntimeException(e);
        }
    }
}

