/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.amazon.kinesis.internal.connection.adapter;

import com.mulesoft.connector.amazon.kinesis.internal.connection.adapter.BufferedContentSubscriber;
import com.mulesoft.connector.amazon.kinesis.internal.connection.adapter.KinesisConsumerAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.internal.async.ByteBuffersAsyncRequestBody;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;

public class KinesisConsumerAsyncAdapter
extends KinesisConsumerAdapter
implements SdkAsyncHttpClient {
    private final HttpClient httpClient;
    private final int responseTimeout;

    public KinesisConsumerAsyncAdapter(HttpClient httpClient, int responseTimeout) {
        this.httpClient = httpClient;
        this.responseTimeout = responseTimeout;
    }

    public CompletableFuture<Void> execute(AsyncExecuteRequest asyncExecuteRequest) {
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        BufferedContentSubscriber subscriber = new BufferedContentSubscriber();
        asyncExecuteRequest.requestContentPublisher().subscribe((Subscriber)subscriber);
        HttpRequest request = ((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(asyncExecuteRequest.request().getUri()).headers(this.transformAwsToMuleHeaders(asyncExecuteRequest.request().headers()))).addHeader("Connection", "close")).entity((HttpEntity)new ByteArrayHttpEntity(subscriber.getContent()))).method(asyncExecuteRequest.request().method().name()).build();
        this.httpClient.sendAsync(request, HttpRequestOptions.builder().responseTimeout(this.responseTimeout).build()).thenAccept(httpResponse -> {
            SdkHttpFullResponse responseAwsType = SdkHttpFullResponse.builder().content(AbortableInputStream.create((InputStream)httpResponse.getEntity().getContent())).headers(this.transformMuleToAwsHeaders((HttpResponse)httpResponse)).statusCode(httpResponse.getStatusCode()).statusText(httpResponse.getReasonPhrase()).build();
            try {
                asyncExecuteRequest.responseHandler().onHeaders((SdkHttpResponse)responseAwsType);
                asyncExecuteRequest.responseHandler().onStream((Publisher)ByteBuffersAsyncRequestBody.from((String)httpResponse.getHeaderValue("Content-Type"), (byte[])httpResponse.getEntity().getBytes()));
                promise.complete(null);
            }
            catch (IOException e) {
                promise.completeExceptionally(e);
            }
        });
        return promise;
    }

    public String clientName() {
        return this.httpClient.getClass().getName();
    }

    public void close() {
    }
}

