/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.amazon.kinesis.internal.connection.adapter;

import com.mulesoft.connector.amazon.kinesis.internal.connection.adapter.KinesisConsumerAdapter;
import com.mulesoft.connector.amazon.kinesis.internal.error.exception.TimeoutException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.ExecutableHttpRequest;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.HttpExecuteResponse;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpResponse;

public class KinesisConsumerSyncAdapter
extends KinesisConsumerAdapter
implements SdkHttpClient {
    private final HttpClient httpClient;
    private final int responseTimeout;

    public KinesisConsumerSyncAdapter(HttpClient httpClient, int responseTimeout) {
        this.httpClient = httpClient;
        this.responseTimeout = responseTimeout;
    }

    public ExecutableHttpRequest prepareRequest(final HttpExecuteRequest request) {
        return new ExecutableHttpRequest(){

            public HttpExecuteResponse call() throws IOException {
                HttpResponse httpResponse;
                Optional contentStreamProvider = request.contentStreamProvider();
                Object httpEntity = contentStreamProvider.isPresent() ? new ByteArrayHttpEntity(IOUtils.toByteArray((InputStream)((ContentStreamProvider)contentStreamProvider.get()).newStream())) : new EmptyHttpEntity();
                HttpRequest httpRequest = ((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(request.httpRequest().getUri()).headers(KinesisConsumerSyncAdapter.this.transformAwsToMuleHeaders(request.httpRequest().headers()))).addHeader("Connection", "close")).entity((HttpEntity)httpEntity)).method(request.httpRequest().method().name()).build();
                try {
                    httpResponse = KinesisConsumerSyncAdapter.this.httpClient.send(httpRequest, HttpRequestOptions.builder().responseTimeout(KinesisConsumerSyncAdapter.this.responseTimeout).build());
                }
                catch (java.util.concurrent.TimeoutException e) {
                    throw new TimeoutException(e);
                }
                SdkHttpFullResponse responseAwsType = SdkHttpFullResponse.builder().content(AbortableInputStream.create((InputStream)httpResponse.getEntity().getContent())).headers(KinesisConsumerSyncAdapter.this.transformMuleToAwsHeaders(httpResponse)).statusCode(httpResponse.getStatusCode()).statusText(httpResponse.getReasonPhrase()).build();
                return HttpExecuteResponse.builder().response((SdkHttpResponse)responseAwsType).responseBody(AbortableInputStream.create((InputStream)httpResponse.getEntity().getContent())).build();
            }

            public void abort() {
            }
        };
    }

    public String clientName() {
        return this.httpClient.getClass().getName();
    }

    public void close() {
    }
}

