/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.amazon.kinesis.internal.connection.client;

import com.mulesoft.connector.amazon.kinesis.internal.connection.sts.ConsumerRoleCredentialsProvider;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import java.util.function.Supplier;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public abstract class AbstractDelegate {
    public static final String SECURITY_TOKEN_EXPIRED = "The security token included in the request is expired";
    protected final AwsCredentialsProvider credentialsProvider;

    protected AbstractDelegate(AwsCredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    protected <T, R> CompletableFuture<R> invokeFuture(Function<T, CompletableFuture<R>> function, T param) {
        return function.apply(param).exceptionally(t -> {
            if (this.refreshRoleCredentials((Throwable)t)) {
                return this.invokeFuture(function, param).join();
            }
            throw new CompletionException((Throwable)t);
        });
    }

    protected <T, R> R invoke(Function<T, R> function, T param) {
        try {
            return function.apply(param);
        }
        catch (Exception e) {
            if (this.refreshRoleCredentials(e)) {
                return this.invoke(function, param);
            }
            throw e;
        }
    }

    protected <T> CompletableFuture<T> invokeFuture(Supplier<CompletableFuture<T>> function) {
        return function.get().exceptionally(t -> {
            if (this.refreshRoleCredentials((Throwable)t)) {
                return this.invokeFuture(function).join();
            }
            throw new CompletionException((Throwable)t);
        });
    }

    protected <T> T invoke(Supplier<T> function) {
        try {
            return function.get();
        }
        catch (Exception e) {
            if (this.refreshRoleCredentials(e)) {
                return this.invoke(function);
            }
            throw e;
        }
    }

    protected boolean refreshRoleCredentials(Throwable e) {
        if (e.getMessage() != null && e.getMessage().contains(SECURITY_TOKEN_EXPIRED) && this.credentialsProvider instanceof ConsumerRoleCredentialsProvider) {
            ((ConsumerRoleCredentialsProvider)this.credentialsProvider).refreshCredentials();
            return true;
        }
        return false;
    }
}

