/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.amazon.kinesis.internal.connection.client;

import com.mulesoft.connector.amazon.kinesis.internal.connection.client.AbstractDelegate;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClientBuilder;
import software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DeleteAnomalyDetectorRequest;
import software.amazon.awssdk.services.cloudwatch.model.DeleteAnomalyDetectorResponse;
import software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DeleteInsightRulesRequest;
import software.amazon.awssdk.services.cloudwatch.model.DeleteInsightRulesResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesResponse;
import software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesRequest;
import software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesResponse;
import software.amazon.awssdk.services.cloudwatch.model.EnableAlarmActionsRequest;
import software.amazon.awssdk.services.cloudwatch.model.EnableAlarmActionsResponse;
import software.amazon.awssdk.services.cloudwatch.model.EnableInsightRulesRequest;
import software.amazon.awssdk.services.cloudwatch.model.EnableInsightRulesResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetDashboardRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetDashboardResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricDataResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageResponse;
import software.amazon.awssdk.services.cloudwatch.model.ListDashboardsRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListDashboardsResponse;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsResponse;
import software.amazon.awssdk.services.cloudwatch.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutAnomalyDetectorRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutAnomalyDetectorResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutDashboardRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutDashboardResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutInsightRuleRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutInsightRuleResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataResponse;
import software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateRequest;
import software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateResponse;
import software.amazon.awssdk.services.cloudwatch.model.TagResourceRequest;
import software.amazon.awssdk.services.cloudwatch.model.TagResourceResponse;
import software.amazon.awssdk.services.cloudwatch.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloudwatch.model.UntagResourceResponse;
import software.amazon.awssdk.services.cloudwatch.paginators.DescribeAlarmHistoryPublisher;
import software.amazon.awssdk.services.cloudwatch.paginators.DescribeAlarmsPublisher;
import software.amazon.awssdk.services.cloudwatch.paginators.DescribeInsightRulesPublisher;
import software.amazon.awssdk.services.cloudwatch.paginators.GetMetricDataPublisher;
import software.amazon.awssdk.services.cloudwatch.paginators.ListDashboardsPublisher;
import software.amazon.awssdk.services.cloudwatch.paginators.ListMetricsPublisher;

public class CloudWatchAsyncClientDelegate
extends AbstractDelegate
implements CloudWatchAsyncClient {
    private final CloudWatchAsyncClient cloudWatchAsyncClient;

    public CloudWatchAsyncClientDelegate(SdkAsyncHttpClient httpClient, AwsCredentialsProvider credentialsProvider, Region region, String customCloudWatchEndpoint) {
        super(credentialsProvider);
        CloudWatchAsyncClientBuilder cloudWatchAsyncClientBuilder = (CloudWatchAsyncClientBuilder)((CloudWatchAsyncClientBuilder)((CloudWatchAsyncClientBuilder)CloudWatchAsyncClient.builder().httpClient(httpClient)).credentialsProvider(credentialsProvider)).region(region);
        if (!StringUtils.isBlank((CharSequence)customCloudWatchEndpoint)) {
            cloudWatchAsyncClientBuilder.endpointOverride(URI.create(customCloudWatchEndpoint));
        }
        this.cloudWatchAsyncClient = (CloudWatchAsyncClient)cloudWatchAsyncClientBuilder.build();
    }

    public String serviceName() {
        return this.cloudWatchAsyncClient.serviceName();
    }

    public void close() {
        this.cloudWatchAsyncClient.close();
    }

    public CompletableFuture<DeleteAlarmsResponse> deleteAlarms(DeleteAlarmsRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).deleteAlarms(arg_0), request);
    }

    public CompletableFuture<DeleteAlarmsResponse> deleteAlarms(Consumer<DeleteAlarmsRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).deleteAlarms(arg_0), request);
    }

    public CompletableFuture<DeleteAnomalyDetectorResponse> deleteAnomalyDetector(DeleteAnomalyDetectorRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).deleteAnomalyDetector(arg_0), request);
    }

    public CompletableFuture<DeleteAnomalyDetectorResponse> deleteAnomalyDetector(Consumer<DeleteAnomalyDetectorRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).deleteAnomalyDetector(arg_0), request);
    }

    public CompletableFuture<DeleteDashboardsResponse> deleteDashboards(DeleteDashboardsRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).deleteDashboards(arg_0), request);
    }

    public CompletableFuture<DeleteDashboardsResponse> deleteDashboards(Consumer<DeleteDashboardsRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).deleteDashboards(arg_0), request);
    }

    public CompletableFuture<DeleteInsightRulesResponse> deleteInsightRules(DeleteInsightRulesRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).deleteInsightRules(arg_0), request);
    }

    public CompletableFuture<DeleteInsightRulesResponse> deleteInsightRules(Consumer<DeleteInsightRulesRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).deleteInsightRules(arg_0), request);
    }

    public CompletableFuture<DescribeAlarmHistoryResponse> describeAlarmHistory(DescribeAlarmHistoryRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).describeAlarmHistory(arg_0), request);
    }

    public CompletableFuture<DescribeAlarmHistoryResponse> describeAlarmHistory(Consumer<DescribeAlarmHistoryRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).describeAlarmHistory(arg_0), request);
    }

    public CompletableFuture<DescribeAlarmHistoryResponse> describeAlarmHistory() {
        return super.invokeFuture(() -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).describeAlarmHistory());
    }

    public DescribeAlarmHistoryPublisher describeAlarmHistoryPaginator() {
        return super.invoke(() -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).describeAlarmHistoryPaginator());
    }

    public DescribeAlarmHistoryPublisher describeAlarmHistoryPaginator(DescribeAlarmHistoryRequest request) {
        return super.invoke(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).describeAlarmHistoryPaginator(arg_0), request);
    }

    public DescribeAlarmHistoryPublisher describeAlarmHistoryPaginator(Consumer<DescribeAlarmHistoryRequest.Builder> request) {
        return super.invoke(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).describeAlarmHistoryPaginator(arg_0), request);
    }

    public CompletableFuture<DescribeAlarmsResponse> describeAlarms(DescribeAlarmsRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).describeAlarms(arg_0), request);
    }

    public CompletableFuture<DescribeAlarmsResponse> describeAlarms(Consumer<DescribeAlarmsRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).describeAlarms(arg_0), request);
    }

    public CompletableFuture<DescribeAlarmsResponse> describeAlarms() {
        return super.invokeFuture(() -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).describeAlarms());
    }

    public CompletableFuture<DescribeAlarmsForMetricResponse> describeAlarmsForMetric(DescribeAlarmsForMetricRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).describeAlarmsForMetric(arg_0), request);
    }

    public CompletableFuture<DescribeAlarmsForMetricResponse> describeAlarmsForMetric(Consumer<DescribeAlarmsForMetricRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).describeAlarmsForMetric(arg_0), request);
    }

    public DescribeAlarmsPublisher describeAlarmsPaginator() {
        return super.invoke(() -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).describeAlarmsPaginator());
    }

    public DescribeAlarmsPublisher describeAlarmsPaginator(DescribeAlarmsRequest request) {
        return super.invoke(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).describeAlarmsPaginator(arg_0), request);
    }

    public DescribeAlarmsPublisher describeAlarmsPaginator(Consumer<DescribeAlarmsRequest.Builder> request) {
        return super.invoke(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).describeAlarmsPaginator(arg_0), request);
    }

    public CompletableFuture<DescribeAnomalyDetectorsResponse> describeAnomalyDetectors(DescribeAnomalyDetectorsRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).describeAnomalyDetectors(arg_0), request);
    }

    public CompletableFuture<DescribeAnomalyDetectorsResponse> describeAnomalyDetectors(Consumer<DescribeAnomalyDetectorsRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).describeAnomalyDetectors(arg_0), request);
    }

    public CompletableFuture<DescribeInsightRulesResponse> describeInsightRules(DescribeInsightRulesRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).describeInsightRules(arg_0), request);
    }

    public CompletableFuture<DescribeInsightRulesResponse> describeInsightRules(Consumer<DescribeInsightRulesRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).describeInsightRules(arg_0), request);
    }

    public DescribeInsightRulesPublisher describeInsightRulesPaginator(DescribeInsightRulesRequest request) {
        return super.invoke(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).describeInsightRulesPaginator(arg_0), request);
    }

    public DescribeInsightRulesPublisher describeInsightRulesPaginator(Consumer<DescribeInsightRulesRequest.Builder> request) {
        return super.invoke(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).describeInsightRulesPaginator(arg_0), request);
    }

    public CompletableFuture<DisableAlarmActionsResponse> disableAlarmActions(DisableAlarmActionsRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).disableAlarmActions(arg_0), request);
    }

    public CompletableFuture<DisableAlarmActionsResponse> disableAlarmActions(Consumer<DisableAlarmActionsRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).disableAlarmActions(arg_0), request);
    }

    public CompletableFuture<DisableInsightRulesResponse> disableInsightRules(DisableInsightRulesRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).disableInsightRules(arg_0), request);
    }

    public CompletableFuture<DisableInsightRulesResponse> disableInsightRules(Consumer<DisableInsightRulesRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).disableInsightRules(arg_0), request);
    }

    public CompletableFuture<EnableAlarmActionsResponse> enableAlarmActions(EnableAlarmActionsRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).enableAlarmActions(arg_0), request);
    }

    public CompletableFuture<EnableAlarmActionsResponse> enableAlarmActions(Consumer<EnableAlarmActionsRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).enableAlarmActions(arg_0), request);
    }

    public CompletableFuture<EnableInsightRulesResponse> enableInsightRules(EnableInsightRulesRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).enableInsightRules(arg_0), request);
    }

    public CompletableFuture<EnableInsightRulesResponse> enableInsightRules(Consumer<EnableInsightRulesRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).enableInsightRules(arg_0), request);
    }

    public CompletableFuture<GetDashboardResponse> getDashboard(GetDashboardRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).getDashboard(arg_0), request);
    }

    public CompletableFuture<GetDashboardResponse> getDashboard(Consumer<GetDashboardRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).getDashboard(arg_0), request);
    }

    public CompletableFuture<GetInsightRuleReportResponse> getInsightRuleReport(GetInsightRuleReportRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).getInsightRuleReport(arg_0), request);
    }

    public CompletableFuture<GetInsightRuleReportResponse> getInsightRuleReport(Consumer<GetInsightRuleReportRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).getInsightRuleReport(arg_0), request);
    }

    public CompletableFuture<GetMetricDataResponse> getMetricData(GetMetricDataRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).getMetricData(arg_0), request);
    }

    public CompletableFuture<GetMetricDataResponse> getMetricData(Consumer<GetMetricDataRequest.Builder> request) {
        return super.invoke(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).getMetricData(arg_0), request);
    }

    public GetMetricDataPublisher getMetricDataPaginator(GetMetricDataRequest request) {
        return super.invoke(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).getMetricDataPaginator(arg_0), request);
    }

    public GetMetricDataPublisher getMetricDataPaginator(Consumer<GetMetricDataRequest.Builder> request) {
        return super.invoke(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).getMetricDataPaginator(arg_0), request);
    }

    public CompletableFuture<GetMetricStatisticsResponse> getMetricStatistics(GetMetricStatisticsRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).getMetricStatistics(arg_0), request);
    }

    public CompletableFuture<GetMetricStatisticsResponse> getMetricStatistics(Consumer<GetMetricStatisticsRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).getMetricStatistics(arg_0), request);
    }

    public CompletableFuture<GetMetricWidgetImageResponse> getMetricWidgetImage(GetMetricWidgetImageRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).getMetricWidgetImage(arg_0), request);
    }

    public CompletableFuture<GetMetricWidgetImageResponse> getMetricWidgetImage(Consumer<GetMetricWidgetImageRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).getMetricWidgetImage(arg_0), request);
    }

    public CompletableFuture<ListDashboardsResponse> listDashboards(ListDashboardsRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).listDashboards(arg_0), request);
    }

    public CompletableFuture<ListDashboardsResponse> listDashboards(Consumer<ListDashboardsRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).listDashboards(arg_0), request);
    }

    public CompletableFuture<ListDashboardsResponse> listDashboards() {
        return super.invokeFuture(() -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).listDashboards());
    }

    public ListDashboardsPublisher listDashboardsPaginator() {
        return super.invoke(() -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).listDashboardsPaginator());
    }

    public ListDashboardsPublisher listDashboardsPaginator(ListDashboardsRequest request) {
        return super.invoke(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).listDashboardsPaginator(arg_0), request);
    }

    public ListDashboardsPublisher listDashboardsPaginator(Consumer<ListDashboardsRequest.Builder> request) {
        return super.invoke(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).listDashboardsPaginator(arg_0), request);
    }

    public CompletableFuture<ListMetricsResponse> listMetrics(ListMetricsRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).listMetrics(arg_0), request);
    }

    public CompletableFuture<ListMetricsResponse> listMetrics(Consumer<ListMetricsRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).listMetrics(arg_0), request);
    }

    public CompletableFuture<ListMetricsResponse> listMetrics() {
        return super.invokeFuture(() -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).listMetrics());
    }

    public ListMetricsPublisher listMetricsPaginator() {
        return super.invoke(() -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).listMetricsPaginator());
    }

    public ListMetricsPublisher listMetricsPaginator(ListMetricsRequest request) {
        return super.invoke(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).listMetricsPaginator(arg_0), request);
    }

    public ListMetricsPublisher listMetricsPaginator(Consumer<ListMetricsRequest.Builder> request) {
        return super.invoke(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).listMetricsPaginator(arg_0), request);
    }

    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).listTagsForResource(arg_0), request);
    }

    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).listTagsForResource(arg_0), request);
    }

    public CompletableFuture<PutAnomalyDetectorResponse> putAnomalyDetector(PutAnomalyDetectorRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).putAnomalyDetector(arg_0), request);
    }

    public CompletableFuture<PutAnomalyDetectorResponse> putAnomalyDetector(Consumer<PutAnomalyDetectorRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).putAnomalyDetector(arg_0), request);
    }

    public CompletableFuture<PutDashboardResponse> putDashboard(PutDashboardRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).putDashboard(arg_0), request);
    }

    public CompletableFuture<PutDashboardResponse> putDashboard(Consumer<PutDashboardRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).putDashboard(arg_0), request);
    }

    public CompletableFuture<PutInsightRuleResponse> putInsightRule(PutInsightRuleRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).putInsightRule(arg_0), request);
    }

    public CompletableFuture<PutInsightRuleResponse> putInsightRule(Consumer<PutInsightRuleRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).putInsightRule(arg_0), request);
    }

    public CompletableFuture<PutMetricAlarmResponse> putMetricAlarm(PutMetricAlarmRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).putMetricAlarm(arg_0), request);
    }

    public CompletableFuture<PutMetricAlarmResponse> putMetricAlarm(Consumer<PutMetricAlarmRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).putMetricAlarm(arg_0), request);
    }

    public CompletableFuture<PutMetricDataResponse> putMetricData(PutMetricDataRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).putMetricData(arg_0), request);
    }

    public CompletableFuture<PutMetricDataResponse> putMetricData(Consumer<PutMetricDataRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).putMetricData(arg_0), request);
    }

    public CompletableFuture<SetAlarmStateResponse> setAlarmState(SetAlarmStateRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).setAlarmState(arg_0), request);
    }

    public CompletableFuture<SetAlarmStateResponse> setAlarmState(Consumer<SetAlarmStateRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).setAlarmState(arg_0), request);
    }

    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).tagResource(arg_0), request);
    }

    public CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).tagResource(arg_0), request);
    }

    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).untagResource(arg_0), request);
    }

    public CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchAsyncClient).untagResource(arg_0), request);
    }
}

