/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.amazon.kinesis.internal.connection.client;

import com.mulesoft.connector.amazon.kinesis.internal.connection.client.AbstractDelegate;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClientBuilder;
import software.amazon.awssdk.services.kinesis.KinesisServiceClientConfiguration;
import software.amazon.awssdk.services.kinesis.internal.KinesisServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.kinesis.model.AddTagsToStreamRequest;
import software.amazon.awssdk.services.kinesis.model.AddTagsToStreamResponse;
import software.amazon.awssdk.services.kinesis.model.CreateStreamRequest;
import software.amazon.awssdk.services.kinesis.model.CreateStreamResponse;
import software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodRequest;
import software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodResponse;
import software.amazon.awssdk.services.kinesis.model.DeleteStreamRequest;
import software.amazon.awssdk.services.kinesis.model.DeleteStreamResponse;
import software.amazon.awssdk.services.kinesis.model.DeregisterStreamConsumerRequest;
import software.amazon.awssdk.services.kinesis.model.DeregisterStreamConsumerResponse;
import software.amazon.awssdk.services.kinesis.model.DescribeLimitsRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeLimitsResponse;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerResponse;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryResponse;
import software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringRequest;
import software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringResponse;
import software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringRequest;
import software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringResponse;
import software.amazon.awssdk.services.kinesis.model.GetRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.GetRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodRequest;
import software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodResponse;
import software.amazon.awssdk.services.kinesis.model.ListShardsRequest;
import software.amazon.awssdk.services.kinesis.model.ListShardsResponse;
import software.amazon.awssdk.services.kinesis.model.ListStreamConsumersRequest;
import software.amazon.awssdk.services.kinesis.model.ListStreamConsumersResponse;
import software.amazon.awssdk.services.kinesis.model.ListStreamsRequest;
import software.amazon.awssdk.services.kinesis.model.ListStreamsResponse;
import software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest;
import software.amazon.awssdk.services.kinesis.model.ListTagsForStreamResponse;
import software.amazon.awssdk.services.kinesis.model.MergeShardsRequest;
import software.amazon.awssdk.services.kinesis.model.MergeShardsResponse;
import software.amazon.awssdk.services.kinesis.model.PutRecordRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordResponse;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerRequest;
import software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerResponse;
import software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamRequest;
import software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamResponse;
import software.amazon.awssdk.services.kinesis.model.SplitShardRequest;
import software.amazon.awssdk.services.kinesis.model.SplitShardResponse;
import software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionRequest;
import software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionResponse;
import software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionRequest;
import software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionResponse;
import software.amazon.awssdk.services.kinesis.model.SubscribeToShardRequest;
import software.amazon.awssdk.services.kinesis.model.SubscribeToShardResponseHandler;
import software.amazon.awssdk.services.kinesis.model.UpdateShardCountRequest;
import software.amazon.awssdk.services.kinesis.model.UpdateShardCountResponse;
import software.amazon.awssdk.services.kinesis.paginators.ListStreamConsumersPublisher;

public class KinesisAsyncClientDelegate
extends AbstractDelegate
implements KinesisAsyncClient {
    private final KinesisAsyncClient kinesisAsyncClient;

    public KinesisAsyncClientDelegate(SdkAsyncHttpClient httpClient, AwsCredentialsProvider credentialsProvider, Region region, String customKinesisEndpoint) {
        super(credentialsProvider);
        KinesisAsyncClientBuilder kinesisAsyncClientBuilder = (KinesisAsyncClientBuilder)((KinesisAsyncClientBuilder)((KinesisAsyncClientBuilder)KinesisAsyncClient.builder().httpClient(httpClient)).credentialsProvider(credentialsProvider)).region(region);
        if (!StringUtils.isBlank((CharSequence)customKinesisEndpoint)) {
            kinesisAsyncClientBuilder.endpointOverride(URI.create(customKinesisEndpoint));
        }
        this.kinesisAsyncClient = (KinesisAsyncClient)kinesisAsyncClientBuilder.build();
    }

    public String serviceName() {
        return this.kinesisAsyncClient.serviceName();
    }

    public void close() {
        this.kinesisAsyncClient.close();
    }

    public CompletableFuture<AddTagsToStreamResponse> addTagsToStream(AddTagsToStreamRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).addTagsToStream(arg_0), request);
    }

    public CompletableFuture<AddTagsToStreamResponse> addTagsToStream(Consumer<AddTagsToStreamRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).addTagsToStream(arg_0), request);
    }

    public CompletableFuture<CreateStreamResponse> createStream(CreateStreamRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).createStream(arg_0), request);
    }

    public CompletableFuture<CreateStreamResponse> createStream(Consumer<CreateStreamRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).createStream(arg_0), request);
    }

    public CompletableFuture<DecreaseStreamRetentionPeriodResponse> decreaseStreamRetentionPeriod(DecreaseStreamRetentionPeriodRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).decreaseStreamRetentionPeriod(arg_0), request);
    }

    public CompletableFuture<DecreaseStreamRetentionPeriodResponse> decreaseStreamRetentionPeriod(Consumer<DecreaseStreamRetentionPeriodRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).decreaseStreamRetentionPeriod(arg_0), request);
    }

    public CompletableFuture<DeleteStreamResponse> deleteStream(DeleteStreamRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).deleteStream(arg_0), request);
    }

    public CompletableFuture<DeleteStreamResponse> deleteStream(Consumer<DeleteStreamRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).deleteStream(arg_0), request);
    }

    public CompletableFuture<DeregisterStreamConsumerResponse> deregisterStreamConsumer(DeregisterStreamConsumerRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).deregisterStreamConsumer(arg_0), request);
    }

    public CompletableFuture<DeregisterStreamConsumerResponse> deregisterStreamConsumer(Consumer<DeregisterStreamConsumerRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).deregisterStreamConsumer(arg_0), request);
    }

    public CompletableFuture<DescribeLimitsResponse> describeLimits(DescribeLimitsRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).describeLimits(arg_0), request);
    }

    public CompletableFuture<DescribeLimitsResponse> describeLimits(Consumer<DescribeLimitsRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).describeLimits(arg_0), request);
    }

    public CompletableFuture<DescribeLimitsResponse> describeLimits() {
        return super.invokeFuture(() -> ((KinesisAsyncClient)this.kinesisAsyncClient).describeLimits());
    }

    public CompletableFuture<DescribeStreamResponse> describeStream(DescribeStreamRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).describeStream(arg_0), request);
    }

    public CompletableFuture<DescribeStreamResponse> describeStream(Consumer<DescribeStreamRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).describeStream(arg_0), request);
    }

    public CompletableFuture<DescribeStreamConsumerResponse> describeStreamConsumer(DescribeStreamConsumerRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).describeStreamConsumer(arg_0), request);
    }

    public CompletableFuture<DescribeStreamConsumerResponse> describeStreamConsumer(Consumer<DescribeStreamConsumerRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).describeStreamConsumer(arg_0), request);
    }

    public CompletableFuture<DescribeStreamSummaryResponse> describeStreamSummary(DescribeStreamSummaryRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).describeStreamSummary(arg_0), request);
    }

    public CompletableFuture<DescribeStreamSummaryResponse> describeStreamSummary(Consumer<DescribeStreamSummaryRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).describeStreamSummary(arg_0), request);
    }

    public CompletableFuture<DisableEnhancedMonitoringResponse> disableEnhancedMonitoring(DisableEnhancedMonitoringRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).disableEnhancedMonitoring(arg_0), request);
    }

    public CompletableFuture<DisableEnhancedMonitoringResponse> disableEnhancedMonitoring(Consumer<DisableEnhancedMonitoringRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).disableEnhancedMonitoring(arg_0), request);
    }

    public CompletableFuture<EnableEnhancedMonitoringResponse> enableEnhancedMonitoring(EnableEnhancedMonitoringRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).enableEnhancedMonitoring(arg_0), request);
    }

    public CompletableFuture<EnableEnhancedMonitoringResponse> enableEnhancedMonitoring(Consumer<EnableEnhancedMonitoringRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).enableEnhancedMonitoring(arg_0), request);
    }

    public CompletableFuture<GetRecordsResponse> getRecords(GetRecordsRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).getRecords(arg_0), request);
    }

    public CompletableFuture<GetRecordsResponse> getRecords(Consumer<GetRecordsRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).getRecords(arg_0), request);
    }

    public CompletableFuture<GetShardIteratorResponse> getShardIterator(GetShardIteratorRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).getShardIterator(arg_0), request);
    }

    public CompletableFuture<GetShardIteratorResponse> getShardIterator(Consumer<GetShardIteratorRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).getShardIterator(arg_0), request);
    }

    public CompletableFuture<IncreaseStreamRetentionPeriodResponse> increaseStreamRetentionPeriod(IncreaseStreamRetentionPeriodRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).increaseStreamRetentionPeriod(arg_0), request);
    }

    public CompletableFuture<IncreaseStreamRetentionPeriodResponse> increaseStreamRetentionPeriod(Consumer<IncreaseStreamRetentionPeriodRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).increaseStreamRetentionPeriod(arg_0), request);
    }

    public CompletableFuture<ListShardsResponse> listShards(ListShardsRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).listShards(arg_0), request);
    }

    public CompletableFuture<ListShardsResponse> listShards(Consumer<ListShardsRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).listShards(arg_0), request);
    }

    public CompletableFuture<ListStreamConsumersResponse> listStreamConsumers(ListStreamConsumersRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).listStreamConsumers(arg_0), request);
    }

    public CompletableFuture<ListStreamConsumersResponse> listStreamConsumers(Consumer<ListStreamConsumersRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).listStreamConsumers(arg_0), request);
    }

    public ListStreamConsumersPublisher listStreamConsumersPaginator(ListStreamConsumersRequest request) {
        return super.invoke(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).listStreamConsumersPaginator(arg_0), request);
    }

    public ListStreamConsumersPublisher listStreamConsumersPaginator(Consumer<ListStreamConsumersRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).listStreamConsumersPaginator(arg_0), request);
    }

    public CompletableFuture<ListStreamsResponse> listStreams(ListStreamsRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).listStreams(arg_0), request);
    }

    public CompletableFuture<ListStreamsResponse> listStreams(Consumer<ListStreamsRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).listStreams(arg_0), request);
    }

    public CompletableFuture<ListStreamsResponse> listStreams() {
        return super.invokeFuture(() -> ((KinesisAsyncClient)this.kinesisAsyncClient).listStreams());
    }

    public CompletableFuture<ListTagsForStreamResponse> listTagsForStream(ListTagsForStreamRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).listTagsForStream(arg_0), request);
    }

    public CompletableFuture<ListTagsForStreamResponse> listTagsForStream(Consumer<ListTagsForStreamRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).listTagsForStream(arg_0), request);
    }

    public CompletableFuture<MergeShardsResponse> mergeShards(MergeShardsRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).mergeShards(arg_0), request);
    }

    public CompletableFuture<MergeShardsResponse> mergeShards(Consumer<MergeShardsRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).mergeShards(arg_0), request);
    }

    public CompletableFuture<PutRecordResponse> putRecord(PutRecordRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).putRecord(arg_0), request);
    }

    public CompletableFuture<PutRecordResponse> putRecord(Consumer<PutRecordRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).putRecord(arg_0), request);
    }

    public CompletableFuture<PutRecordsResponse> putRecords(PutRecordsRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).putRecords(arg_0), request);
    }

    public CompletableFuture<PutRecordsResponse> putRecords(Consumer<PutRecordsRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).putRecords(arg_0), request);
    }

    public CompletableFuture<RegisterStreamConsumerResponse> registerStreamConsumer(RegisterStreamConsumerRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).registerStreamConsumer(arg_0), request);
    }

    public CompletableFuture<RegisterStreamConsumerResponse> registerStreamConsumer(Consumer<RegisterStreamConsumerRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).registerStreamConsumer(arg_0), request);
    }

    public CompletableFuture<RemoveTagsFromStreamResponse> removeTagsFromStream(RemoveTagsFromStreamRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).removeTagsFromStream(arg_0), request);
    }

    public CompletableFuture<RemoveTagsFromStreamResponse> removeTagsFromStream(Consumer<RemoveTagsFromStreamRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).removeTagsFromStream(arg_0), request);
    }

    public CompletableFuture<SplitShardResponse> splitShard(SplitShardRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).splitShard(arg_0), request);
    }

    public CompletableFuture<SplitShardResponse> splitShard(Consumer<SplitShardRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).splitShard(arg_0), request);
    }

    public CompletableFuture<StartStreamEncryptionResponse> startStreamEncryption(StartStreamEncryptionRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).startStreamEncryption(arg_0), request);
    }

    public CompletableFuture<StartStreamEncryptionResponse> startStreamEncryption(Consumer<StartStreamEncryptionRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).startStreamEncryption(arg_0), request);
    }

    public CompletableFuture<StopStreamEncryptionResponse> stopStreamEncryption(StopStreamEncryptionRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).stopStreamEncryption(arg_0), request);
    }

    public CompletableFuture<StopStreamEncryptionResponse> stopStreamEncryption(Consumer<StopStreamEncryptionRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).stopStreamEncryption(arg_0), request);
    }

    public CompletableFuture<Void> subscribeToShard(SubscribeToShardRequest request, SubscribeToShardResponseHandler asyncResponseHandler) {
        return super.invokeFuture(client -> client.subscribeToShard(request, asyncResponseHandler), this.kinesisAsyncClient);
    }

    public CompletableFuture<Void> subscribeToShard(Consumer<SubscribeToShardRequest.Builder> builder, SubscribeToShardResponseHandler asyncResponseHandler) {
        return super.invokeFuture(client -> client.subscribeToShard(builder, asyncResponseHandler), this.kinesisAsyncClient);
    }

    public CompletableFuture<UpdateShardCountResponse> updateShardCount(UpdateShardCountRequest request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).updateShardCount(arg_0), request);
    }

    public CompletableFuture<UpdateShardCountResponse> updateShardCount(Consumer<UpdateShardCountRequest.Builder> request) {
        return super.invokeFuture(arg_0 -> ((KinesisAsyncClient)this.kinesisAsyncClient).updateShardCount(arg_0), request);
    }

    public KinesisServiceClientConfiguration serviceClientConfiguration() {
        try {
            Field field = this.kinesisAsyncClient.getClass().getDeclaredField("clientConfiguration");
            field.setAccessible(true);
            SdkClientConfiguration conf = (SdkClientConfiguration)field.get(this.kinesisAsyncClient);
            return new KinesisServiceClientConfigurationBuilder(conf.toBuilder()).build();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

