/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.amazon.kinesis.internal.connection.client;

import com.mulesoft.connector.amazon.kinesis.internal.connection.client.AbstractDelegate;
import java.net.URI;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.KinesisClientBuilder;
import software.amazon.awssdk.services.kinesis.model.AddTagsToStreamRequest;
import software.amazon.awssdk.services.kinesis.model.AddTagsToStreamResponse;
import software.amazon.awssdk.services.kinesis.model.CreateStreamRequest;
import software.amazon.awssdk.services.kinesis.model.CreateStreamResponse;
import software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodRequest;
import software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodResponse;
import software.amazon.awssdk.services.kinesis.model.DeleteStreamRequest;
import software.amazon.awssdk.services.kinesis.model.DeleteStreamResponse;
import software.amazon.awssdk.services.kinesis.model.DeregisterStreamConsumerRequest;
import software.amazon.awssdk.services.kinesis.model.DeregisterStreamConsumerResponse;
import software.amazon.awssdk.services.kinesis.model.DescribeLimitsRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeLimitsResponse;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerResponse;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryResponse;
import software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringRequest;
import software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringResponse;
import software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringRequest;
import software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringResponse;
import software.amazon.awssdk.services.kinesis.model.GetRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.GetRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodRequest;
import software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodResponse;
import software.amazon.awssdk.services.kinesis.model.ListShardsRequest;
import software.amazon.awssdk.services.kinesis.model.ListShardsResponse;
import software.amazon.awssdk.services.kinesis.model.ListStreamConsumersRequest;
import software.amazon.awssdk.services.kinesis.model.ListStreamConsumersResponse;
import software.amazon.awssdk.services.kinesis.model.ListStreamsRequest;
import software.amazon.awssdk.services.kinesis.model.ListStreamsResponse;
import software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest;
import software.amazon.awssdk.services.kinesis.model.ListTagsForStreamResponse;
import software.amazon.awssdk.services.kinesis.model.MergeShardsRequest;
import software.amazon.awssdk.services.kinesis.model.MergeShardsResponse;
import software.amazon.awssdk.services.kinesis.model.PutRecordRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordResponse;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerRequest;
import software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerResponse;
import software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamRequest;
import software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamResponse;
import software.amazon.awssdk.services.kinesis.model.SplitShardRequest;
import software.amazon.awssdk.services.kinesis.model.SplitShardResponse;
import software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionRequest;
import software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionResponse;
import software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionRequest;
import software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionResponse;
import software.amazon.awssdk.services.kinesis.model.UpdateShardCountRequest;
import software.amazon.awssdk.services.kinesis.model.UpdateShardCountResponse;
import software.amazon.awssdk.services.kinesis.paginators.ListStreamConsumersIterable;

public class KinesisClientDelegate
extends AbstractDelegate
implements KinesisClient {
    private final KinesisClient kinesisClient;

    public KinesisClientDelegate(SdkHttpClient httpClient, AwsCredentialsProvider credentialsProvider, Region region, String customKinesisEndpoint) {
        super(credentialsProvider);
        KinesisClientBuilder kinesisClientBuilder = (KinesisClientBuilder)((KinesisClientBuilder)((KinesisClientBuilder)KinesisClient.builder().httpClient(httpClient)).credentialsProvider(credentialsProvider)).region(region);
        if (!StringUtils.isBlank((CharSequence)customKinesisEndpoint)) {
            kinesisClientBuilder.endpointOverride(URI.create(customKinesisEndpoint));
        }
        this.kinesisClient = (KinesisClient)kinesisClientBuilder.build();
    }

    public String serviceName() {
        return this.kinesisClient.serviceName();
    }

    public void close() {
        this.kinesisClient.close();
    }

    public AddTagsToStreamResponse addTagsToStream(AddTagsToStreamRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).addTagsToStream(arg_0), request);
    }

    public AddTagsToStreamResponse addTagsToStream(Consumer<AddTagsToStreamRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).addTagsToStream(arg_0), request);
    }

    public CreateStreamResponse createStream(CreateStreamRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).createStream(arg_0), request);
    }

    public CreateStreamResponse createStream(Consumer<CreateStreamRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).createStream(arg_0), request);
    }

    public DecreaseStreamRetentionPeriodResponse decreaseStreamRetentionPeriod(DecreaseStreamRetentionPeriodRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).decreaseStreamRetentionPeriod(arg_0), request);
    }

    public DecreaseStreamRetentionPeriodResponse decreaseStreamRetentionPeriod(Consumer<DecreaseStreamRetentionPeriodRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).decreaseStreamRetentionPeriod(arg_0), request);
    }

    public DeleteStreamResponse deleteStream(DeleteStreamRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).deleteStream(arg_0), request);
    }

    public DeleteStreamResponse deleteStream(Consumer<DeleteStreamRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).deleteStream(arg_0), request);
    }

    public DeregisterStreamConsumerResponse deregisterStreamConsumer(DeregisterStreamConsumerRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).deregisterStreamConsumer(arg_0), request);
    }

    public DeregisterStreamConsumerResponse deregisterStreamConsumer(Consumer<DeregisterStreamConsumerRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).deregisterStreamConsumer(arg_0), request);
    }

    public DescribeLimitsResponse describeLimits() {
        return super.invoke(() -> ((KinesisClient)this.kinesisClient).describeLimits());
    }

    public DescribeLimitsResponse describeLimits(DescribeLimitsRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).describeLimits(arg_0), request);
    }

    public DescribeLimitsResponse describeLimits(Consumer<DescribeLimitsRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).describeLimits(arg_0), request);
    }

    public DescribeStreamResponse describeStream(DescribeStreamRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).describeStream(arg_0), request);
    }

    public DescribeStreamResponse describeStream(Consumer<DescribeStreamRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).describeStream(arg_0), request);
    }

    public DescribeStreamConsumerResponse describeStreamConsumer(DescribeStreamConsumerRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).describeStreamConsumer(arg_0), request);
    }

    public DescribeStreamConsumerResponse describeStreamConsumer(Consumer<DescribeStreamConsumerRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).describeStreamConsumer(arg_0), request);
    }

    public DescribeStreamSummaryResponse describeStreamSummary(DescribeStreamSummaryRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).describeStreamSummary(arg_0), request);
    }

    public DescribeStreamSummaryResponse describeStreamSummary(Consumer<DescribeStreamSummaryRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).describeStreamSummary(arg_0), request);
    }

    public DisableEnhancedMonitoringResponse disableEnhancedMonitoring(DisableEnhancedMonitoringRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).disableEnhancedMonitoring(arg_0), request);
    }

    public DisableEnhancedMonitoringResponse disableEnhancedMonitoring(Consumer<DisableEnhancedMonitoringRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).disableEnhancedMonitoring(arg_0), request);
    }

    public EnableEnhancedMonitoringResponse enableEnhancedMonitoring(EnableEnhancedMonitoringRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).enableEnhancedMonitoring(arg_0), request);
    }

    public EnableEnhancedMonitoringResponse enableEnhancedMonitoring(Consumer<EnableEnhancedMonitoringRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).enableEnhancedMonitoring(arg_0), request);
    }

    public GetRecordsResponse getRecords(GetRecordsRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).getRecords(arg_0), request);
    }

    public GetRecordsResponse getRecords(Consumer<GetRecordsRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).getRecords(arg_0), request);
    }

    public GetShardIteratorResponse getShardIterator(GetShardIteratorRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).getShardIterator(arg_0), request);
    }

    public GetShardIteratorResponse getShardIterator(Consumer<GetShardIteratorRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).getShardIterator(arg_0), request);
    }

    public IncreaseStreamRetentionPeriodResponse increaseStreamRetentionPeriod(IncreaseStreamRetentionPeriodRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).increaseStreamRetentionPeriod(arg_0), request);
    }

    public IncreaseStreamRetentionPeriodResponse increaseStreamRetentionPeriod(Consumer<IncreaseStreamRetentionPeriodRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).increaseStreamRetentionPeriod(arg_0), request);
    }

    public ListShardsResponse listShards(ListShardsRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).listShards(arg_0), request);
    }

    public ListShardsResponse listShards(Consumer<ListShardsRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).listShards(arg_0), request);
    }

    public ListStreamConsumersResponse listStreamConsumers(ListStreamConsumersRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).listStreamConsumers(arg_0), request);
    }

    public ListStreamConsumersResponse listStreamConsumers(Consumer<ListStreamConsumersRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).listStreamConsumers(arg_0), request);
    }

    public ListStreamConsumersIterable listStreamConsumersPaginator(ListStreamConsumersRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).listStreamConsumersPaginator(arg_0), request);
    }

    public ListStreamConsumersIterable listStreamConsumersPaginator(Consumer<ListStreamConsumersRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).listStreamConsumersPaginator(arg_0), request);
    }

    public ListStreamsResponse listStreams() {
        return super.invoke(() -> ((KinesisClient)this.kinesisClient).listStreams());
    }

    public ListStreamsResponse listStreams(ListStreamsRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).listStreams(arg_0), request);
    }

    public ListStreamsResponse listStreams(Consumer<ListStreamsRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).listStreams(arg_0), request);
    }

    public ListTagsForStreamResponse listTagsForStream(ListTagsForStreamRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).listTagsForStream(arg_0), request);
    }

    public ListTagsForStreamResponse listTagsForStream(Consumer<ListTagsForStreamRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).listTagsForStream(arg_0), request);
    }

    public MergeShardsResponse mergeShards(MergeShardsRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).mergeShards(arg_0), request);
    }

    public MergeShardsResponse mergeShards(Consumer<MergeShardsRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).mergeShards(arg_0), request);
    }

    public PutRecordResponse putRecord(PutRecordRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).putRecord(arg_0), request);
    }

    public PutRecordResponse putRecord(Consumer<PutRecordRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).putRecord(arg_0), request);
    }

    public PutRecordsResponse putRecords(PutRecordsRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).putRecords(arg_0), request);
    }

    public PutRecordsResponse putRecords(Consumer<PutRecordsRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).putRecords(arg_0), request);
    }

    public RegisterStreamConsumerResponse registerStreamConsumer(RegisterStreamConsumerRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).registerStreamConsumer(arg_0), request);
    }

    public RegisterStreamConsumerResponse registerStreamConsumer(Consumer<RegisterStreamConsumerRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).registerStreamConsumer(arg_0), request);
    }

    public RemoveTagsFromStreamResponse removeTagsFromStream(RemoveTagsFromStreamRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).removeTagsFromStream(arg_0), request);
    }

    public RemoveTagsFromStreamResponse removeTagsFromStream(Consumer<RemoveTagsFromStreamRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).removeTagsFromStream(arg_0), request);
    }

    public SplitShardResponse splitShard(SplitShardRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).splitShard(arg_0), request);
    }

    public SplitShardResponse splitShard(Consumer<SplitShardRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).splitShard(arg_0), request);
    }

    public StartStreamEncryptionResponse startStreamEncryption(StartStreamEncryptionRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).startStreamEncryption(arg_0), request);
    }

    public StartStreamEncryptionResponse startStreamEncryption(Consumer<StartStreamEncryptionRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).startStreamEncryption(arg_0), request);
    }

    public StopStreamEncryptionResponse stopStreamEncryption(StopStreamEncryptionRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).stopStreamEncryption(arg_0), request);
    }

    public StopStreamEncryptionResponse stopStreamEncryption(Consumer<StopStreamEncryptionRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).stopStreamEncryption(arg_0), request);
    }

    public UpdateShardCountResponse updateShardCount(UpdateShardCountRequest request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).updateShardCount(arg_0), request);
    }

    public UpdateShardCountResponse updateShardCount(Consumer<UpdateShardCountRequest.Builder> request) {
        return super.invoke(arg_0 -> ((KinesisClient)this.kinesisClient).updateShardCount(arg_0), request);
    }
}

