/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.amazon.kinesis.internal.connection.provider;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connector.amazon.kinesis.api.ProxyConfiguration;
import com.mulesoft.connector.amazon.kinesis.internal.connection.KinesisConnection;
import com.mulesoft.connector.amazon.kinesis.internal.connection.KinesisConnectionImpl;
import com.mulesoft.connector.amazon.kinesis.internal.connection.provider.parameter.AccessKeyParameters;
import com.mulesoft.connectors.commons.template.connection.provider.ConnectorConnectionProvider;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.proxy.NtlmProxyConfigBuilder;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="connection")
@DisplayName(value="Kinesis Connection")
public class KinesisConnectionProvider
implements ConnectorConnectionProvider<KinesisConnection>,
CachedConnectionProvider<KinesisConnection>,
Initialisable,
Disposable {
    private static final Logger logger = LoggerFactory.getLogger(KinesisConnectionProvider.class);
    @ParameterGroup(name="Connection")
    @Placement(order=1)
    private AccessKeyParameters accessKeyParameters;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Summary(value="For custom Kinesis endpoint, e.g. for FIPS")
    @Placement(tab="Advanced", order=4)
    @DisplayName(value="Custom Kinesis Endpoint")
    private String customKinesisEndpoint;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Summary(value="Sets a custom STS endpoint. Useful when a non-standard service endpoint is required, such as a VPC or FIPS endpoint.")
    @Placement(tab="Advanced", order=5)
    @DisplayName(value="Custom STS endpoint")
    private String customStsEndpoint;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Summary(value="Proxy connection settings for outbound connections. This setting applies to the Listener source and Checkpoint operation. It does not affect the Put Record operation.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=6)
    @DisplayName(value="Proxy Configuration")
    private ProxyConfiguration proxyParameterGroup;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Summary(value="Protocol to use for communication. When using the HTTPS protocol, the HTTP communication is secured using TLS or SSL. If HTTPS is configured as the protocol, then, at a minimum, you must configure the keystore in the tls:context child element of the listener-config. This setting applies to the Listener source and Checkpoint operation. It does not affect the Put Record operation.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Security", order=1)
    @DisplayName(value="TLS Configuration")
    private TlsContextFactory tlsContext;
    @Inject
    private HttpService httpService;
    @Inject
    private SchedulerService schedulerService;
    @RefName
    private String configName;
    @Inject
    private SchedulerConfig schedulerConfig;
    private HttpClient httpClient;
    private ObjectMapper objectMapper;
    private Scheduler kplCallbackScheduler;

    public void initialise() throws InitialisationException {
        this.kplCallbackScheduler = this.schedulerService.ioScheduler(this.schedulerConfig.withName(String.format("%s_KplCallbackScheduler", this.configName)));
        this.objectMapper = new ObjectMapper();
        LifecycleUtils.initialiseIfNeeded((Object)this.tlsContext);
        this.httpClient = this.httpService.getClientFactory().create(new HttpClientConfiguration.Builder().setTlsContextFactory(this.tlsContext).setClientSocketProperties(TcpClientSocketProperties.builder().connectionTimeout(Integer.valueOf((int)this.accessKeyParameters.getConnectionTimeoutInMillis())).build()).setProxyConfig((ProxyConfig)Optional.ofNullable(this.proxyParameterGroup).map(proxy -> Optional.ofNullable(proxy.getNtlmDomain()).map(arg_0 -> ((NtlmProxyConfigBuilder)ProxyConfig.NtlmProxyConfig.builder()).ntlmDomain(arg_0)).orElseGet(ProxyConfig::builder).username(proxy.getUsername()).password(proxy.getPassword()).host(proxy.getHost()).port(proxy.getPort()).nonProxyHosts(String.join((CharSequence)",", proxy.getNonProxyHosts())).build()).orElse(null)).setName(this.configName).build());
        this.httpClient.start();
        logger.debug("Mule HTTP client started.");
    }

    public KinesisConnection connect() {
        return new KinesisConnectionImpl(this.httpClient, this.accessKeyParameters.getAccessKey(), this.accessKeyParameters.getSecretKey(), this.accessKeyParameters.getRegion(), this.accessKeyParameters.getRole(), (int)this.accessKeyParameters.getResponseTimeoutInMillis(), this.kplCallbackScheduler, this.objectMapper, this.customKinesisEndpoint, this.customStsEndpoint, this.accessKeyParameters.getCustomDynamoDBEndpoint(), this.accessKeyParameters.getCustomCloudWatchEndpoint());
    }

    public void dispose() {
        this.kplCallbackScheduler.stop();
        if (this.httpClient != null) {
            this.httpClient.stop();
        }
    }
}

