/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.amazon.kinesis.internal.connection.provider.parameter;

import com.mulesoft.connector.amazon.kinesis.api.Role;
import com.mulesoft.connector.amazon.kinesis.internal.connection.provider.parameter.RegionValuesProvider;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.sdk.api.annotation.semantics.security.Username;

public class AccessKeyParameters {
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Access Key")
    @Placement(order=1)
    @Summary(value="Access key provided by Amazon.")
    @Username
    private String accessKey;
    @Parameter
    @Password
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Secret Key")
    @Placement(order=2)
    @Summary(value="Secret key provided by Amazon.")
    private String secretKey;
    @OfValues(value=RegionValuesProvider.class)
    @Optional(defaultValue="us-east-1")
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Region Endpoint")
    @Placement(order=3)
    @Summary(value="Topic region endpoint.")
    private String region;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional
    @DisplayName(value="Role")
    @Placement(order=4)
    @Summary(value="Role configuration.")
    private Role role;
    @Parameter
    @DisplayName(value="Custom Dynamo DB Endpoint")
    @Optional
    @Placement(order=5)
    @Summary(value="Sets a Dynamo DB Endpoint to track and maintain state information.")
    private String customDynamoDBEndpoint;
    @Parameter
    @DisplayName(value="Custom Cloud Watch Endpoint")
    @Optional
    @Placement(order=6)
    @Summary(value="Sets a Cloud Watch Endpoint for monitoring and observability.")
    private String customCloudWatchEndpoint;
    @Parameter
    @Optional(defaultValue="30")
    @DisplayName(value="Connection Timeout")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=1)
    @Summary(value="The amount of time to wait when initially establishing the TCP connection between the connector and Amazon Kinesis server before throwing an exception if the connection fails.")
    private int connectionTimeout;
    @Parameter
    @Optional(defaultValue="SECONDS")
    @DisplayName(value="Connection Timeout Time Unit")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=2)
    @Summary(value="The time unit for Connection Timeout value.")
    private TimeUnit connectionTimeoutUnit;
    @Parameter
    @Optional(defaultValue="30")
    @DisplayName(value="Response Timeout")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=3)
    @Summary(value="The maximum time to wait between the time an HTTP request is sent and when a response is received.")
    private int responseTimeout;
    @Parameter
    @Optional(defaultValue="SECONDS")
    @DisplayName(value="Response Timeout Unit")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=4)
    @Summary(value="Time unit for the Response Timeout value.")
    private TimeUnit responseTimeoutUnit;

    public AccessKeyParameters() {
    }

    public AccessKeyParameters(String accessKey, String secretKey, String region, Role role) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.region = region;
        this.role = role;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public Role getRole() {
        return this.role;
    }

    public String getCustomDynamoDBEndpoint() {
        return this.customDynamoDBEndpoint;
    }

    public String getCustomCloudWatchEndpoint() {
        return this.customCloudWatchEndpoint;
    }

    public long getConnectionTimeoutInMillis() {
        return this.connectionTimeoutUnit.toMillis(this.connectionTimeout);
    }

    public long getResponseTimeoutInMillis() {
        return this.responseTimeoutUnit.toMillis(this.responseTimeout);
    }
}

