/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.amazon.kinesis.internal.connection.provider.parameter;

import com.mulesoft.connector.amazon.kinesis.api.ShardConfig;
import com.mulesoft.connector.amazon.kinesis.api.ShardPrioritization;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class CommonListenerParameters {
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Stream Name")
    @Summary(value="The stream name.")
    private String streamName;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Application Name")
    @Summary(value="Name of the DynamoDB table that holds data about current stream positions. If the table doesn't exist, then the connector creates a new one at the initial position.")
    private String applicationName;
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Shard Configs")
    @Summary(value="The shard configuration. If specified, the listener listens only from selected shards.")
    private List<ShardConfig> shardConfigs;
    @Parameter
    @Optional(defaultValue="10000")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Max Batch Size")
    @Summary(value="The maximum number of data records that a batch can carry.")
    private int maxBatchSize;
    @Parameter
    @Optional(defaultValue="2137483647")
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Max Leases For Worker")
    @Summary(value="Number of shards to which the listener can subscribe in parallel.")
    private int maxLeasesForWorker;
    @Parameter
    @Optional(defaultValue="NO_OP_SHARD_PRIORITIZATION")
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Shard Prioritization")
    @Summary(value="Logic used to prioritize or filter the shards before their execution.")
    private ShardPrioritization shardPrioritization;
    @Parameter
    @Optional
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Max Depth")
    @Summary(value="Used by the PARENTS_FIRST_SHARD_PRIORITIZATION shard prioritization option. Any shard that is deeper than this value is excluded from processing.")
    private int maxDepth;
    @Parameter
    @Optional(defaultValue="10")
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Read Capacity Units")
    @Summary(value="The maximum number of strongly consistent reads consumed per second before Amazon DynamoDB returns a ThrottlingException.")
    private long readCapacityUnits;
    @Parameter
    @Optional(defaultValue="10")
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Write Capacity Units")
    @Summary(value="The maximum number of writes consumed per second before Amazon DynamoDB returns a ThrottlingException.")
    private long writeCapacityUnits;
    @Parameter
    @Optional(defaultValue="10")
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Failover Time")
    @Summary(value="Duration of a lease for a worker. This parameter also determines the frequency with which a worker looks for new leases to work on. The frequency is roughly twice the specified value.")
    private long failoverTime;
    @Parameter
    @Optional(defaultValue="SECONDS")
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Failover Time Unit")
    @Summary(value="Time unit for the Failover Time value.")
    private TimeUnit failoverTimeUnit;
    @Parameter
    @Optional(defaultValue="true")
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Checkpoint On Complete")
    @Summary(value="If true, the listener checkpoints the current reading position to Amazon DynamoDB after data records are processed by the owning flow, without taking into account whether the processing finished successfully.")
    private boolean checkpointOnComplete;

    public String getStreamName() {
        return this.streamName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public int getMaxLeasesForWorker() {
        return this.maxLeasesForWorker;
    }

    public ShardPrioritization getShardPrioritization() {
        return this.shardPrioritization;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public List<ShardConfig> getShardConfigs() {
        return this.shardConfigs;
    }

    public long getReadCapacityUnits() {
        return this.readCapacityUnits;
    }

    public long getWriteCapacityUnits() {
        return this.writeCapacityUnits;
    }

    public long getFailoverTimeInMillis() {
        return this.failoverTimeUnit.toMillis(this.failoverTime);
    }

    public boolean isCheckpointOnComplete() {
        return this.checkpointOnComplete;
    }
}

