/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.amazon.kinesis.internal.connection.sts;

import com.mulesoft.connector.amazon.kinesis.api.Role;
import com.mulesoft.connector.amazon.kinesis.internal.error.exception.AssumeRoleException;
import com.mulesoft.connector.amazon.kinesis.internal.error.exception.RegionDisabledException;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;
import software.amazon.awssdk.services.sts.model.PolicyDescriptorType;
import software.amazon.awssdk.services.sts.model.Tag;

public abstract class AbstractCredentialsProvider {
    protected AssumeRoleResponse assumeRole(StsClient stsClient, Role role) {
        AssumeRoleRequest.Builder stsRequestBuilder = AssumeRoleRequest.builder().durationSeconds(Integer.valueOf(Math.toIntExact(role.getDurationTimeUnit().toSeconds(role.getDuration())))).externalId(role.getExternalId()).policyArns((Collection)Optional.ofNullable(role.getReferredPolicyArns()).filter(arns -> !arns.isEmpty()).map(arns -> arns.stream().map(arn -> (PolicyDescriptorType)PolicyDescriptorType.builder().arn(arn).build()).collect(Collectors.toList())).orElse(null)).roleArn(role.getArn()).roleSessionName("mule-kinesis-connector-role-" + UUID.randomUUID()).tags((Collection)Optional.ofNullable(role.getTags()).map(tags -> tags.entrySet().stream().map(tag -> (Tag)Tag.builder().key((String)tag.getKey()).value((String)tag.getValue()).build()).collect(Collectors.toList())).orElse(null));
        try {
            return stsClient.assumeRole((AssumeRoleRequest)stsRequestBuilder.build());
        }
        catch (software.amazon.awssdk.services.sts.model.RegionDisabledException e) {
            throw new RegionDisabledException(e);
        }
        catch (SdkException e) {
            throw new AssumeRoleException(e);
        }
    }
}

