/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.amazon.kinesis.internal.connection.sts;

import com.mulesoft.connector.amazon.kinesis.api.Role;
import com.mulesoft.connector.amazon.kinesis.internal.connection.sts.AbstractCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

public class ConsumerRoleCredentialsProvider
extends AbstractCredentialsProvider
implements AwsCredentialsProvider {
    private Role role;
    private StsClient stsClient;
    private volatile AwsCredentials currentCredentials;

    public ConsumerRoleCredentialsProvider(StsClient stsClient, Role role) {
        this.role = (Role)Validate.notNull((Object)role, (String)"ConsumerRole must not be null.", (Object[])new Object[0]);
        this.stsClient = stsClient;
        this.refreshCredentials();
    }

    public void refreshCredentials() {
        AssumeRoleResponse assumeRoleResponse = this.assumeRole(this.stsClient, this.role);
        this.currentCredentials = AwsSessionCredentials.create((String)assumeRoleResponse.credentials().accessKeyId(), (String)assumeRoleResponse.credentials().secretAccessKey(), (String)assumeRoleResponse.credentials().sessionToken());
    }

    public AwsCredentials resolveCredentials() {
        return this.currentCredentials;
    }

    public String toString() {
        return ToString.builder((String)"StaticCredentialsProvider").add("credentials", (Object)this.currentCredentials).build();
    }
}

