/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.amazon.kinesis.internal.connection.sts;

import com.mulesoft.connector.amazon.kinesis.api.Role;
import com.mulesoft.connector.amazon.kinesis.internal.connection.sts.AbstractCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;
import software.amazon.awssdk.utils.ToString;

public class ProducerRoleCredentialsProvider
extends AbstractCredentialsProvider
implements AwsCredentialsProvider {
    private final Role role;
    private final StsClient stsClient;
    private volatile AwsCredentials currentCredentials;

    public ProducerRoleCredentialsProvider(StsClient stsClient, Role role) {
        this.role = role;
        this.stsClient = stsClient;
        this.refreshCredentials();
    }

    public AwsCredentials resolveCredentials() {
        return this.currentCredentials;
    }

    public void refreshCredentials() {
        AssumeRoleResponse assumeRoleResponse = this.assumeRole(this.stsClient, this.role);
        this.currentCredentials = AwsSessionCredentials.create((String)assumeRoleResponse.credentials().accessKeyId(), (String)assumeRoleResponse.credentials().secretAccessKey(), (String)assumeRoleResponse.credentials().sessionToken());
    }

    public String toString() {
        return ToString.builder((String)"ProducerRoleCredentialsProvider").add("credentials", (Object)this.currentCredentials).build();
    }
}

