/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.amazon.kinesis.internal.operation;

import com.mulesoft.connector.amazon.kinesis.internal.config.KinesisConfiguration;
import com.mulesoft.connector.amazon.kinesis.internal.error.exception.InvalidArgumentException;
import com.mulesoft.connector.amazon.kinesis.internal.error.exception.KinesisRuntimeException;
import com.mulesoft.connector.amazon.kinesis.internal.error.provider.CheckpointErrorTypeProvider;
import com.mulesoft.connector.amazon.kinesis.internal.source.consumer.ConsumerManager;
import javax.inject.Inject;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;

@Throws(value={CheckpointErrorTypeProvider.class})
public class CheckpointOperation {
    @Inject
    private ConsumerManager consumerManager;

    @DisplayName(value="Checkpoint")
    @Alias(value="checkpoint")
    public void checkpoint(@Config KinesisConfiguration config, @DisplayName(value="Stream Name") String streamName, @DisplayName(value="Application Name") String applicationName, @DisplayName(value="Shard ID") @Optional String shardId, @DisplayName(value="Sequence Number") @Optional String sequenceNumber, @DisplayName(value="Subsequence Number") @Optional Long subsequenceNumber, CompletionCallback<Void, Void> callback) {
        if (applicationName == null) {
            callback.error((Throwable)((Object)new InvalidArgumentException("Application name cannot be null.")));
            return;
        }
        if (streamName == null) {
            callback.error((Throwable)((Object)new InvalidArgumentException("Stream name cannot be null.")));
            return;
        }
        if (subsequenceNumber != null && sequenceNumber == null) {
            callback.error((Throwable)((Object)new InvalidArgumentException("Sequence number cannot be null when subsequence number is specified.")));
            return;
        }
        if (shardId == null && sequenceNumber != null) {
            callback.error((Throwable)((Object)new InvalidArgumentException("Shard id cannot be null when sequence number is specified.")));
            return;
        }
        try {
            this.consumerManager.checkpoint(applicationName, streamName, shardId, sequenceNumber, subsequenceNumber);
            callback.success(Result.builder().build());
        }
        catch (ModuleException e) {
            callback.error((Throwable)e);
        }
        catch (Exception e) {
            callback.error((Throwable)((Object)new KinesisRuntimeException(e)));
        }
    }
}

