/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.amazon.kinesis.internal.operation;

import com.mulesoft.connector.amazon.kinesis.internal.config.KinesisConfiguration;
import com.mulesoft.connector.amazon.kinesis.internal.connection.KinesisConnection;
import com.mulesoft.connector.amazon.kinesis.internal.error.provider.PutRecordErrorTypeProvider;
import java.io.InputStream;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputJsonType;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;

@Throws(value={PutRecordErrorTypeProvider.class})
public class PutRecordOperation {
    @DisplayName(value="Put Record")
    @MediaType(value="application/json")
    @OutputJsonType(schema="metadata/put-record-schema.json")
    public void putRecord(@Config KinesisConfiguration config, @Connection KinesisConnection connection, @DisplayName(value="Stream Name") String streamName, @Summary(value="The partition key. If not provided, the connector generates a UUID for this value.") @DisplayName(value="Partition Key") @Optional @Placement(tab="Advanced") String partitionKey, @Summary(value="Overrides the Amazon Kinesis Data Streams explicitHashKey value, which is normally computed with using MD5 function of the data record partition key.") @DisplayName(value="Explicit Hash Key") @Optional @Placement(tab="Advanced") String explicitHashKey, @Summary(value="The content to put in the Amazon Kinesis data stream. This content can be up to 1 MB in size.") @DisplayName(value="Data") @Content InputStream data, CompletionCallback<InputStream, Void> callback) {
        connection.putRecord(data, partitionKey, explicitHashKey, streamName, config.getAdvancedProducerParameters(), callback);
    }
}

