/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.amazon.kinesis.internal.source.consumer;

import com.mulesoft.connector.amazon.kinesis.api.RecordAttributes;
import com.mulesoft.connector.amazon.kinesis.internal.error.exception.IllegalStateException;
import com.mulesoft.connector.amazon.kinesis.internal.error.exception.InvalidArgumentException;
import com.mulesoft.connector.amazon.kinesis.internal.source.consumer.Consumer;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;

public class ConsumerManager
implements Initialisable,
Disposable {
    private static final String CONSUMER_ID_FORMAT = "%s#%s";
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private SchedulerConfig schedulerConfig;
    private Scheduler muleKclScheduler;
    private MultiMap<String, Consumer> consumers;

    private ConsumerManager() {
    }

    public void initialise() {
        this.consumers = new MultiMap();
        this.muleKclScheduler = this.schedulerService.ioScheduler(this.schedulerConfig.withName("kinesis-connector-mule-scheduler-" + UUID.randomUUID().toString()).withShutdownTimeout(20L, TimeUnit.SECONDS));
    }

    public void dispose() {
        this.muleKclScheduler.stop();
    }

    public synchronized Consumer addConsumer(Consumer consumer, SourceCallback<List<Result<InputStream, RecordAttributes>>, Void> sourceCallback) {
        consumer.startConsumer(this.muleKclScheduler, sourceCallback);
        this.consumers.put((Object)this.getConsumerId(consumer), (Object)consumer);
        return consumer;
    }

    public synchronized void removeConsumer(Consumer consumer) {
        List formerConsumers = this.consumers.removeAll((Object)this.getConsumerId(consumer));
        formerConsumers.remove(consumer);
        if (!formerConsumers.isEmpty()) {
            this.consumers.put((Object)this.getConsumerId(consumer), (Collection)formerConsumers);
        }
        consumer.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint(String applicationName, String streamName, String shardId, String sequenceNumber, Long subsequenceNumber) {
        List matchingConsumers;
        ConsumerManager consumerManager = this;
        synchronized (consumerManager) {
            matchingConsumers = this.consumers.getAll((Object)this.getConsumerId(applicationName, streamName));
        }
        if (matchingConsumers.isEmpty()) {
            throw new InvalidArgumentException(String.format("No active listener found with matching application name '%s' and stream name '%s'.", applicationName, streamName));
        }
        if (shardId != null) {
            List matchingShardIdConsumers = matchingConsumers.stream().filter(consumer -> consumer.consumesShard(shardId)).collect(Collectors.toList());
            if (matchingShardIdConsumers.size() > 1) {
                throw new IllegalStateException(String.format("Multiple listeners found with matching application name '%s' and stream name '%s', and actively consuming from the same shard '%s'.", applicationName, streamName, shardId));
            }
            if (matchingShardIdConsumers.isEmpty()) {
                throw new InvalidArgumentException(String.format("No active listener found with matching application name '%s', stream name '%s', and actively consuming from the shard '%s'.", applicationName, streamName, shardId));
            }
            matchingConsumers.forEach(consumer -> consumer.checkpoint(shardId, sequenceNumber, subsequenceNumber));
        } else {
            if (matchingConsumers.size() > 1) {
                throw new InvalidArgumentException(String.format("Multiple listeners found with matching application name '%s' and stream name '%s'.", applicationName, streamName));
            }
            matchingConsumers.forEach(Consumer::checkpoint);
        }
    }

    public String getConsumerId(String applicationName, String streamName) {
        return String.format(CONSUMER_ID_FORMAT, applicationName, streamName);
    }

    private String getConsumerId(Consumer consumer) {
        return this.getConsumerId(consumer.getApplicationName(), consumer.getStreamName());
    }
}

