/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.internal.source;

import com.mulesoft.extension.mq.api.message.AnypointMQMessageContext;
import com.mulesoft.extension.mq.internal.config.AnypointMQConfiguration;
import com.mulesoft.extension.mq.internal.config.SubscriberAckMode;
import com.mulesoft.extension.mq.internal.connection.AnypointMQConnection;
import com.mulesoft.extension.mq.internal.server.AnypointMQServer;
import com.mulesoft.mq.restclient.api.Destination;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;

@Alias(value="subscriber")
@MediaType(value="*/*", strict=false)
public class AnypointMQSource
extends Source<byte[], AnypointMQMessageContext> {
    @Parameter
    private String destination;
    @Connection
    private ConnectionProvider<AnypointMQConnection> connectionProvider;
    @Config
    private AnypointMQConfiguration config;
    private AnypointMQServer server;

    public void onStart(SourceCallback<byte[], AnypointMQMessageContext> callback) throws ConnectionException {
        this.server = new AnypointMQServer(this.destination, this.config, (AnypointMQConnection)this.connectionProvider.connect(), callback);
    }

    public void onStop() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @OnSuccess
    public void onSuccess(SourceCallbackContext callbackContext) throws Exception {
        SubscriberAckMode acknowledgementMode = (SubscriberAckMode)((Object)callbackContext.getVariable("ACKNOWLEDGEMENT_MODE").get());
        Destination destination = (Destination)callbackContext.getVariable("DESTINATION").get();
        AnypointMQMessageContext messageContext = (AnypointMQMessageContext)callbackContext.getVariable("MESSAGE_CONTEXT").get();
        try {
            if (acknowledgementMode.equals((Object)SubscriberAckMode.AUTO)) {
                destination.ack(messageContext.getMessage()).fireAndForget();
            }
        }
        catch (Exception e) {
            destination.nack(messageContext.getMessage()).fireAndForget();
        }
    }

    @OnError
    public void onError(SourceCallbackContext callbackContext) {
        SubscriberAckMode acknowledgementMode = (SubscriberAckMode)((Object)callbackContext.getVariable("ACKNOWLEDGEMENT_MODE").get());
        Destination destination = (Destination)callbackContext.getVariable("DESTINATION").get();
        AnypointMQMessageContext messageContext = (AnypointMQMessageContext)callbackContext.getVariable("MESSAGE_CONTEXT").get();
        if (acknowledgementMode.equals((Object)SubscriberAckMode.AUTO)) {
            destination.nack(messageContext.getMessage()).fireAndForget();
        }
    }
}

