/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.internal;

import com.mulesoft.extension.mq.api.message.AnypointMQMessageContext;
import com.mulesoft.extension.mq.api.message.MessageContextFactory;
import com.mulesoft.extension.mq.internal.config.SubscriberAckMode;
import com.mulesoft.extension.mq.internal.config.SubscriberConfiguration;
import com.mulesoft.extension.mq.internal.domain.MessageListener;
import com.mulesoft.mq.restclient.api.AnypointMqMessage;
import com.mulesoft.mq.restclient.api.Destination;
import com.mulesoft.mq.restclient.internal.AbstractCourierRestClient;
import com.mulesoft.mq.restclient.internal.ExecutorUtils;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSubscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSubscriber.class);
    public static final long DEFAULT_POLLING_TIME = 1000L;
    public static final String DEFAULT_POLLING_TIME_STRING = "1000";
    private final MessageListener messageListener;
    private final MessageContextFactory messageContextFactory;
    protected final Destination destination;
    protected final SubscriberConfiguration subscriberConfiguration;
    protected final ScheduledExecutorService executorService;
    protected boolean running;

    public AbstractSubscriber(SubscriberConfiguration subscriberConfiguration, Destination destination, MessageListener messageListener, MessageContextFactory messageContextFactory, int pollingThreads) {
        this.subscriberConfiguration = subscriberConfiguration;
        this.destination = destination;
        this.messageListener = messageListener;
        this.messageContextFactory = messageContextFactory;
        if (pollingThreads < 1 || pollingThreads > 5) {
            throw new IllegalArgumentException("Polling threads must be between 1 to 5. Received: " + pollingThreads);
        }
        this.executorService = Executors.newScheduledThreadPool(pollingThreads);
    }

    public synchronized void start() {
        this.running = true;
        LOGGER.trace("Starting Subscriber");
        this.submitWork();
    }

    protected void submitWork() {
        if (this.running) {
            this.doSubmitWork();
        }
    }

    protected abstract void doSubmitWork();

    protected void handleError(Throwable e) {
        if (!AbstractCourierRestClient.isTimeout((Throwable)e)) {
            this.messageListener.onError(e);
        }
    }

    protected void processMessages(List<AnypointMqMessage> messages) {
        if (this.running) {
            for (AnypointMqMessage message : messages) {
                AnypointMQMessageContext messageContext = this.messageContextFactory.createMessageContext(message, this.destination.getName());
                if (this.subscriberConfiguration.getAcknowledgementMode() == SubscriberAckMode.IMMEDIATE) {
                    this.destination.ack(messageContext.getMessage()).fireAndForget();
                }
                this.messageListener.onReceive(messageContext);
            }
        }
    }

    public synchronized void stop() {
        this.running = false;
        LOGGER.trace("Stopping Subscriber");
        ExecutorUtils.stopExecutorService((ExecutorService)this.executorService);
    }
}

