/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.internal;

import com.mulesoft.extension.mq.api.message.MessageContextFactory;
import com.mulesoft.extension.mq.internal.AbstractSubscriber;
import com.mulesoft.extension.mq.internal.config.SubscriberConfiguration;
import com.mulesoft.extension.mq.internal.domain.MessageListener;
import com.mulesoft.mq.restclient.api.AnypointMqMessage;
import com.mulesoft.mq.restclient.api.CourierObserver;
import com.mulesoft.mq.restclient.api.Destination;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingSubscriber
extends AbstractSubscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollingSubscriber.class);
    private static final int POLLING_THREADS = 2;
    private static final int BATCH_SIZE = 10;
    private final long pollingTime;

    public PollingSubscriber(SubscriberConfiguration subscriberConfiguration, Destination destination, MessageListener messageListener, MessageContextFactory messageContextFactory) {
        super(subscriberConfiguration, destination, messageListener, messageContextFactory, 2);
        this.pollingTime = subscriberConfiguration.getPollingTime() == null || subscriberConfiguration.getPollingTime() <= 0L ? 1000L : subscriberConfiguration.getPollingTime();
    }

    @Override
    protected void doSubmitWork() {
        this.executorService.scheduleAtFixedRate(() -> {
            try {
                this.subscribeForMessages();
            }
            catch (Throwable t) {
                LOGGER.error("Can not subscribe for messages.", t);
                throw t;
            }
        }, 0L, this.pollingTime, TimeUnit.MILLISECONDS);
    }

    private void subscribeForMessages() {
        this.destination.receive(10, Math.min(this.pollingTime / 2L, 20L), Optional.ofNullable(this.subscriberConfiguration.getAcknowledgementTimeout()).orElse(120000L).longValue()).subscribe((CourierObserver)new CourierObserver<List<AnypointMqMessage>>(){

            public void onSuccess(List<AnypointMqMessage> messages) {
                PollingSubscriber.this.processMessages(messages);
            }

            public void onError(Throwable e) {
                PollingSubscriber.this.handleError(e);
            }
        });
    }
}

