/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.internal;

import com.mulesoft.extension.mq.api.message.MessageContextFactory;
import com.mulesoft.extension.mq.internal.AbstractSubscriber;
import com.mulesoft.extension.mq.internal.config.SubscriberConfiguration;
import com.mulesoft.extension.mq.internal.domain.MessageListener;
import com.mulesoft.mq.restclient.api.AnypointMqMessage;
import com.mulesoft.mq.restclient.api.CourierObserver;
import com.mulesoft.mq.restclient.api.Destination;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefetchSubscriber
extends AbstractSubscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrefetchSubscriber.class);
    private static final int POLLING_THREADS = 1;
    private static final int BATCH_SIZE = 1;

    public PrefetchSubscriber(SubscriberConfiguration subscriberConfiguration, Destination destination, MessageListener messageListener, MessageContextFactory messageContextFactory) {
        super(subscriberConfiguration, destination, messageListener, messageContextFactory, 1);
    }

    @Override
    protected void doSubmitWork() {
        this.executorService.submit(() -> {
            try {
                this.subscribeForMessages();
            }
            catch (Throwable t) {
                LOGGER.error("Can not subscribe for messages.", t);
                throw t;
            }
        });
    }

    private void subscribeForMessages() {
        LOGGER.trace("Subscribing for messages");
        this.destination.receive(1, 0L, 120000L).subscribe((CourierObserver)new CourierObserver<List<AnypointMqMessage>>(){

            public void onSuccess(List<AnypointMqMessage> messages) {
                if (messages != null && !messages.isEmpty()) {
                    PrefetchSubscriber.this.processMessages(messages);
                }
                PrefetchSubscriber.this.submitWork();
            }

            public void onError(Throwable e) {
                PrefetchSubscriber.this.handleError(e);
                PrefetchSubscriber.this.submitWork();
            }
        });
    }
}

