/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.internal.config;

import com.mulesoft.extension.mq.internal.config.MQPrefetchConfiguration;
import com.mulesoft.extension.mq.internal.config.SubscriberAckMode;
import com.mulesoft.extension.mq.internal.config.SubscriberConfiguration;

public class SubscribeConfigurationBuilder {
    private SubscriberAckMode acknowledgementMode;
    private Long acknowledgementTimeout;
    private Long pollingTime;
    private MQPrefetchConfiguration prefetch;
    private Integer maxRedelivery;

    private SubscribeConfigurationBuilder(SubscriberConfiguration defaultSubscriberConfiguration) {
        this.setAcknowledgementMode(defaultSubscriberConfiguration.getAcknowledgementMode());
        this.setAcknowledgementTimeout(defaultSubscriberConfiguration.getAcknowledgementTimeout());
        this.setPrefetch(defaultSubscriberConfiguration.getPrefetch());
    }

    public static SubscribeConfigurationBuilder newBuilderFrom(SubscriberConfiguration subscriberConfiguration) {
        return new SubscribeConfigurationBuilder(subscriberConfiguration);
    }

    public SubscribeConfigurationBuilder setAcknowledgementMode(SubscriberAckMode acknowledgeMode) {
        this.acknowledgementMode = acknowledgeMode;
        return this;
    }

    public SubscribeConfigurationBuilder setAcknowledgementTimeout(Long ackTimeout) {
        this.acknowledgementTimeout = ackTimeout;
        return this;
    }

    public SubscribeConfigurationBuilder setPollingTime(Long pollingTime) {
        this.pollingTime = pollingTime;
        return this;
    }

    public SubscribeConfigurationBuilder setMaxRedelivery(Integer maxRedelivery) {
        this.maxRedelivery = maxRedelivery;
        return this;
    }

    public SubscribeConfigurationBuilder setPrefetch(MQPrefetchConfiguration prefetch) {
        if (prefetch != null) {
            this.prefetch = new MQPrefetchConfiguration();
            this.prefetch.setFetchSize(prefetch.getFetchSize());
            this.prefetch.setFetchTimeout(prefetch.getFetchTimeout());
            this.prefetch.setFrequency(prefetch.getFrequency());
        }
        return this;
    }

    public SubscriberConfiguration build() {
        return new SubscriberConfiguration(){

            @Override
            public SubscriberAckMode getAcknowledgementMode() {
                return SubscribeConfigurationBuilder.this.acknowledgementMode;
            }

            @Override
            public Long getAcknowledgementTimeout() {
                return SubscribeConfigurationBuilder.this.acknowledgementTimeout;
            }

            @Override
            public Long getPollingTime() {
                return SubscribeConfigurationBuilder.this.pollingTime;
            }

            @Override
            public Integer getMaxRedelivery() {
                return SubscribeConfigurationBuilder.this.maxRedelivery;
            }

            @Override
            public MQPrefetchConfiguration getPrefetch() {
                return SubscribeConfigurationBuilder.this.prefetch;
            }
        };
    }
}

