/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.internal.operation;

import com.mulesoft.extension.mq.api.attributes.AnypointMqMessagePublishAttributes;
import com.mulesoft.extension.mq.api.message.AnypointMQMessageContext;
import com.mulesoft.extension.mq.internal.config.AnypointMQConfiguration;
import com.mulesoft.extension.mq.internal.config.ConsumerAckMode;
import com.mulesoft.extension.mq.internal.connection.AnypointMQConnection;
import com.mulesoft.extension.mq.internal.error.AnypointMQErrorTypeProvider;
import com.mulesoft.extension.mq.internal.service.AnypointMQService;
import com.mulesoft.extension.mq.internal.service.AnypointMQServiceImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.runtime.operation.Result;

@Throws(value={AnypointMQErrorTypeProvider.class})
public class AnypointMQOperations {
    @MediaType(value="*/*", strict=false)
    public Result<InputStream, AnypointMqMessagePublishAttributes> publish(@Config AnypointMQConfiguration config, @Connection AnypointMQConnection connection, String destination, @Content(primary=true) @Optional(defaultValue="#[payload]") TypedValue<InputStream> body, @Placement(tab="Advanced") @Optional String messageId, @Placement(tab="Advanced") @Optional(defaultValue="true") boolean sendContentType, @Optional Map<String, String> properties) {
        org.mule.runtime.api.metadata.MediaType mediaType = body.getDataType().getMediaType();
        byte[] messageContent = this.getContent((InputStream)body.getValue());
        return Result.builder().output((Object)new ByteArrayInputStream(messageContent)).mediaType(mediaType).attributes((Object)new AnypointMqMessagePublishAttributes(this.getService(config, connection).publish(destination, messageContent, sendContentType, mediaType.toString(), mediaType.getCharset(), messageId, properties))).build();
    }

    @MediaType(value="*/*", strict=false)
    public Result<InputStream, AnypointMQMessageContext> consume(@Config AnypointMQConfiguration config, @Connection AnypointMQConnection connection, String destination, @Optional(defaultValue="MANUAL") ConsumerAckMode acknowledgementMode, @Optional(defaultValue="10000") Long pollingTime, @Optional(defaultValue="0") Long acknowledgementTimeout) {
        Result.Builder resultBuilder = Result.builder();
        AnypointMQMessageContext messageContext = this.getService(config, connection).consume(destination, acknowledgementMode, pollingTime, acknowledgementTimeout);
        if (messageContext != null) {
            resultBuilder.output((Object)new ByteArrayInputStream(messageContext.getMessage().getBody())).attributes((Object)messageContext);
            Map properties = messageContext.getMessage().getProperties();
            if (properties.containsKey("contentType")) {
                resultBuilder.mediaType(org.mule.runtime.api.metadata.MediaType.parse((String)((String)properties.get("contentType"))));
            }
        }
        return resultBuilder.build();
    }

    public void ack(@Config AnypointMQConfiguration config, @Connection AnypointMQConnection connection, @Expression(value=ExpressionSupport.REQUIRED) AnypointMQMessageContext messageContext) {
        this.getService(config, connection).ack(messageContext);
    }

    public void nack(@Config AnypointMQConfiguration config, @Connection AnypointMQConnection connection, @Expression(value=ExpressionSupport.REQUIRED) AnypointMQMessageContext messageContext) {
        this.getService(config, connection).nack(messageContext);
    }

    private AnypointMQService getService(AnypointMQConfiguration config, AnypointMQConnection connection) {
        return new AnypointMQServiceImpl(config, connection);
    }

    private byte[] getContent(InputStream inputStream) {
        if (inputStream != null) {
            return IOUtils.toByteArray((InputStream)inputStream);
        }
        return new byte[0];
    }
}

