/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.internal.server;

import com.mulesoft.extension.mq.api.message.AnypointMQMessageContext;
import com.mulesoft.extension.mq.internal.AbstractSubscriber;
import com.mulesoft.extension.mq.internal.PollingSubscriber;
import com.mulesoft.extension.mq.internal.PrefetchSubscriber;
import com.mulesoft.extension.mq.internal.config.AnypointMQConfiguration;
import com.mulesoft.extension.mq.internal.config.MQPrefetchConfiguration;
import com.mulesoft.extension.mq.internal.config.SubscriberAckMode;
import com.mulesoft.extension.mq.internal.config.SubscriberConfiguration;
import com.mulesoft.extension.mq.internal.connection.AnypointMQConnection;
import com.mulesoft.extension.mq.internal.domain.MessageListener;
import com.mulesoft.mq.restclient.api.Destination;
import com.mulesoft.mq.restclient.api.exception.ResourceNotFoundException;
import com.mulesoft.mq.restclient.impl.PrefetchedDestination;
import com.mulesoft.mq.restclient.internal.DefaultMessagePreserver;
import com.mulesoft.mq.restclient.internal.MessagePreserver;
import com.mulesoft.mq.restclient.internal.Prefetcher;
import com.mulesoft.mq.restclient.internal.ScheduledPrefetcher;
import com.mulesoft.mq.restclient.internal.TimeSupplier;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnypointMQServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnypointMQServer.class);
    public static final String MESSAGE_CONTEXT_VAR = "MESSAGE_CONTEXT";
    public static final String DESTINATION_VAR = "DESTINATION";
    public static final String ACKNOWLEDGEMENT_MODE_VAR = "ACKNOWLEDGEMENT_MODE";
    private final AnypointMQConnection connection;
    private final SourceCallback<byte[], AnypointMQMessageContext> callback;
    private AbstractSubscriber subscriber;
    private ScheduledPrefetcher prefetcher;

    public AnypointMQServer(String destination, AnypointMQConfiguration config, AnypointMQConnection connection, SourceCallback<byte[], AnypointMQMessageContext> callback) {
        this.connection = connection;
        this.callback = callback;
        Destination courierDestination = connection.getDestination(destination);
        MQPrefetchConfiguration prefetch = config.getPrefetch();
        if (prefetch != null && prefetch.getFetchSize() > 0) {
            this.prefetcher = new ScheduledPrefetcher(courierDestination, prefetch.getFetchSize(), prefetch.getFetchTimeout(), Optional.ofNullable(config.getAcknowledgementTimeout()).orElse(120000L).longValue(), prefetch.getFrequency(), (MessagePreserver)new DefaultMessagePreserver(courierDestination, new TimeSupplier()));
            courierDestination = new PrefetchedDestination(courierDestination, (Prefetcher)this.prefetcher);
            this.subscriber = new PrefetchSubscriber(config, courierDestination, new ExtensionMessageListener(config, courierDestination, this.callback), connection.getMessageContextFactory());
        } else {
            this.subscriber = new PollingSubscriber(config, courierDestination, new ExtensionMessageListener(config, courierDestination, this.callback), connection.getMessageContextFactory());
        }
    }

    public void start() {
        if (this.subscriber != null) {
            this.subscriber.start();
        }
        if (this.prefetcher != null) {
            this.prefetcher.start();
        }
    }

    public void stop() {
        this.connection.disconnect();
        if (this.prefetcher != null) {
            this.prefetcher.stop();
        }
        if (this.subscriber != null) {
            this.subscriber.stop();
        }
    }

    private class ExtensionMessageListener
    implements MessageListener {
        private final SubscriberAckMode acknowledgementMode;
        private final Destination destination;
        private final SourceCallback<byte[], AnypointMQMessageContext> callback;
        private final int maxRedelivery;

        ExtensionMessageListener(SubscriberConfiguration subscriberConfiguration, Destination destination, SourceCallback<byte[], AnypointMQMessageContext> callback) {
            this.acknowledgementMode = Optional.ofNullable(subscriberConfiguration.getAcknowledgementMode()).orElse(SubscriberAckMode.AUTO);
            this.maxRedelivery = Optional.ofNullable(subscriberConfiguration.getMaxRedelivery()).orElse(-1);
            this.destination = destination;
            this.callback = callback;
        }

        @Override
        public void onReceive(AnypointMQMessageContext messageContext) {
            if (this.redeliveryExhausted(messageContext, this.maxRedelivery)) {
                LOGGER.trace("Listener Skipped Message '{}' - Max redelivery reached with '{}' attempts", (Object)messageContext.getMessage().getId(), (Object)messageContext.getMessage().getDeliveryCount());
                return;
            }
            if (this.acknowledgementMode == SubscriberAckMode.IMMEDIATE) {
                this.destination.ack(messageContext.getMessage()).fireAndForget();
            }
            LOGGER.trace("Message received - {}", (Object)messageContext.getMessage().getId());
            this.handleMessage(messageContext);
        }

        private void handleMessage(AnypointMQMessageContext messageContext) {
            Map properties = messageContext.getMessage().getProperties();
            Result.Builder resultbuilder = Result.builder().output((Object)messageContext.getMessage().getBody()).attributes((Object)messageContext);
            if (properties.containsKey("contentType")) {
                resultbuilder.mediaType(MediaType.parse((String)((String)properties.get("contentType"))));
            }
            SourceCallbackContext callbackContext = this.callback.createContext();
            callbackContext.addVariable(AnypointMQServer.ACKNOWLEDGEMENT_MODE_VAR, (Object)this.acknowledgementMode);
            callbackContext.addVariable(AnypointMQServer.DESTINATION_VAR, (Object)this.destination);
            callbackContext.addVariable(AnypointMQServer.MESSAGE_CONTEXT_VAR, (Object)messageContext);
            this.callback.handle(resultbuilder.build(), callbackContext);
            LOGGER.trace("Message dispatched - {}", (Object)messageContext.getMessage().getId());
        }

        @Override
        public void onError(Throwable throwable) {
            if (throwable instanceof ResourceNotFoundException) {
                LOGGER.error("Connection failed - Destination not found: {}", (Object)this.destination);
                this.callback.onConnectionException(new ConnectionException(throwable));
            } else {
                LOGGER.error("Can not process received message.", throwable);
            }
        }

        private boolean redeliveryExhausted(AnypointMQMessageContext messageContext, int maxRedelivery) {
            int redeliveries;
            boolean exhausted = false;
            if (maxRedelivery >= 0 && (redeliveries = messageContext.getMessage().getDeliveryCount() - 1) > maxRedelivery) {
                exhausted = true;
            }
            return exhausted;
        }
    }
}

