package com.mulesoft.extension.mq.api.message;


import org.mule.runtime.api.util.Preconditions;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

import static java.util.Collections.unmodifiableMap;

//TODO REVIEW TO COPY LOGIC
public class MessageBuilder {

    private MessageToDeleteImpl message = new MessageToDeleteImpl();

    public MessageBuilder addProperty(String key, String value) {
        Preconditions.checkArgument(key != null, "key cannot be null");
        Preconditions.checkArgument(value != null, "value cannot be null");
        message.properties.put(key, value);
        return this;
    }

    public MessageBuilder addHeader(String key, String value) {
        Preconditions.checkArgument(key != null, "key cannot be null");
        Preconditions.checkArgument(value != null, "value cannot be null");
        message.headers.put(key, value);
        return this;
    }

    public MessageBuilder setContent(byte[] content) {
        message.content = content;
        return this;
    }

    public MessageBuilder setMessageId(String messageId) {
        message.headers.put(MessageToDelete.Headers.AMQ_MESSAGE_ID, messageId);
        return this;
    }

    public MessageBuilder setLockID(String lockId) {
        message.headers.put(MessageToDelete.Headers.AMQ_LOCK_ID, lockId);
        return this;
    }

    public MessageBuilder setDestination(String destination) {
        message.headers.put("destination", destination);
        return this;
    }

    public MessageBuilder setMessageDeliveryCount(int messageDeliveryCount) {
        message.headers.put(MessageToDelete.Headers.AMQ_DELIVERY_COUNT, String.valueOf(messageDeliveryCount));
        return this;
    }

    public MessageToDelete build() {
        //Either the message has properties or has content. AMQP support message with just properties
        Preconditions.checkState(!message.properties.isEmpty() || message.getContent().isPresent(), "Message cannot have empty content");
        return message;
    }

    public static class MessageToDeleteImpl implements MessageToDelete {

        private byte[] content = null;
        private Map<String, String> properties = new HashMap<>();
        private Map<String, String> headers = new HashMap<>();

        private MessageToDeleteImpl() {
        }

        public Optional<byte[]> getContent() {
            return Optional.ofNullable(content);
        }

        public Map<String, String> getProperties() {
            return unmodifiableMap(properties);
        }

        @Override
        public Map<String, String> getHeaders() {
            return unmodifiableMap(headers);
        }

        @Override
        public Optional<Integer> getMessageDeliveryCount() {
            return Optional.of(Integer.valueOf(headers.get(Headers.AMQ_DELIVERY_COUNT)));
        }

        @Override
        public Optional<String> getMessageId() {
            return Optional.ofNullable(headers.get(Headers.AMQ_MESSAGE_ID));
        }

        @Override
        public Optional<String> getLockId() {
            return Optional.ofNullable(headers.get(Headers.AMQ_LOCK_ID));
        }

        @Override
        public Optional<String> getDestination() {
            return Optional.ofNullable(headers.get("destination"));
        }
    }
}
