package com.mulesoft.extension.mq.api.message;

import java.util.Map;
import java.util.Optional;

/**
 * Messaging message structure.
 */
public interface MessageToDelete {

    String DEFAULT_AMQ_MESSAGE_CONTEXT = "AMQ_MESSAGE_CONTEXT";

    /**
     * @return the content of the message. May be null.
     */
    Optional<byte[]> getContent();

    /**
     * @return the properties of the message
     */
    Map<String, String> getProperties();

    /**
     * @return the headers of the message
     */
    Map<String, String> getHeaders();

    /**
     * @return the number of times the message was delivered. May be empty when provider does not
     * support redelivery.
     */
    Optional<Integer> getMessageDeliveryCount();

    /**
     * @return the message id. May be empty when the provider does not support redelivery.
     */
    Optional<String> getMessageId();

    Optional<String> getLockId();

    Optional<String> getDestination();

    interface Headers {
        String MAP_NAME = "headers";
        String AMQ_LOCK_ID = "lockId";
        String AMQ_DELIVERY_COUNT = "deliveryCount";
        String AMQ_MESSAGE_ID = "messageId";
    }

    interface Properties {
        String MAP_NAME = "properties";
        String AMQ_MESSAGE_CONTENT_TYPE = "contentType";
    }

}
