package com.mulesoft.extension.mq.internal;

import com.mulesoft.extension.mq.internal.config.SubscribeConfigurationBuilder;
import com.mulesoft.extension.mq.internal.config.SubscriberConfiguration;

import java.util.Optional;

public class AnypointMqUtils {

    /**
     * Given two different {@link SubscriberConfiguration} merges them into one, taken precedence
     * the {@code overrideConfiguration} over {@code defaultConfiguration} values.
     *
     * @param defaultConfiguration  configuration from the Connector configuration that can be
     *                              overrided by the specific Subscriber configuration
     * @param overrideConfiguration configuration from the Subscriber that can override values from
     *                              the default configuration
     * @return The merged {@link SubscriberConfiguration}
     */
    @Deprecated
    public static SubscriberConfiguration merge(SubscriberConfiguration defaultConfiguration, SubscriberConfiguration overrideConfiguration) {
        if (overrideConfiguration != null) {
            SubscribeConfigurationBuilder builder = SubscribeConfigurationBuilder.newBuilderFrom(defaultConfiguration);
            builder.setAcknowledgementMode(Optional.ofNullable(overrideConfiguration.getAcknowledgementMode()).orElseGet(defaultConfiguration::getAcknowledgementMode));
            builder.setAcknowledgementTimeout(Optional.ofNullable(overrideConfiguration.getAcknowledgementTimeout()).orElseGet(defaultConfiguration::getAcknowledgementTimeout));
            builder.setPollingTime(Optional.ofNullable(overrideConfiguration.getPollingTime()).orElseGet(defaultConfiguration::getPollingTime));
            builder.setMaxRedelivery(Optional.ofNullable(overrideConfiguration.getMaxRedelivery()).orElseGet(defaultConfiguration::getMaxRedelivery));
            // TODO: allow to set only some prefetch attributes
            Optional.ofNullable(overrideConfiguration.getPrefetch()).map(builder::setPrefetch).get();
            defaultConfiguration = builder.build();
        }
        return defaultConfiguration;
    }
}
