package com.mulesoft.extension.mq.internal;

import static com.mulesoft.mq.restclient.api.Destination.DEFAULT_LOCK_TTL;
import static com.mulesoft.mq.restclient.api.Destination.DEFAULT_POOLING_TIME;

import com.mulesoft.extension.mq.api.message.MessageContextFactory;
import com.mulesoft.extension.mq.internal.config.SubscriberConfiguration;
import com.mulesoft.extension.mq.internal.domain.MessageListener;
import com.mulesoft.mq.restclient.api.AnypointMqMessage;
import com.mulesoft.mq.restclient.api.CourierObserver;
import com.mulesoft.mq.restclient.api.Destination;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefetchSubscriber extends AbstractSubscriber {

  private static final Logger LOGGER = LoggerFactory.getLogger(PrefetchSubscriber.class);
  private static final int POLLING_THREADS = 1;
  private static final int BATCH_SIZE = 1;

  public PrefetchSubscriber(SubscriberConfiguration subscriberConfiguration, Destination destination,
                            MessageListener messageListener, MessageContextFactory messageContextFactory) {
    super(subscriberConfiguration, destination, messageListener, messageContextFactory, POLLING_THREADS);
  }

  @Override
  protected void doSubmitWork() {
    executorService.submit(() -> {
      try {
        subscribeForMessages();
      } catch (Throwable t) {
        LOGGER.error("Can not subscribe for messages.", t);
        throw t;
      }
    });
  }

  private void subscribeForMessages() {
    LOGGER.trace("Subscribing for messages");
    destination
      .receive(BATCH_SIZE,
               DEFAULT_POOLING_TIME,
               DEFAULT_LOCK_TTL)
      .subscribe(new CourierObserver<List<AnypointMqMessage>>() {

        @Override
        public void onSuccess(List<AnypointMqMessage> messages) {
          if (messages != null && !messages.isEmpty()){
            processMessages(messages);
          }
          submitWork();
        }

        @Override
        public void onError(Throwable e) {
          handleError(e);
          submitWork();
        }
      });
  }

}
