/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package com.mulesoft.extension.mq.internal.client;

import com.google.common.base.Preconditions;
import com.mulesoft.mq.restclient.api.AnypointMqClient;
import com.mulesoft.mq.restclient.api.AnypointMqClientFactory;
import com.mulesoft.mq.restclient.api.CourierAuthenticationCredentials;
import com.mulesoft.mq.restclient.impl.OAuthCredentials;
import com.mulesoft.mq.restclient.internal.CourierRestClient;
import com.mulesoft.mq.restclient.internal.client.DefaultAnypointMqClient;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;

public class MuleBasedAnypointMqClientFactory implements AnypointMqClientFactory {

    private final HttpClient httpClient;
    private final Scheduler scheduler;

    public MuleBasedAnypointMqClientFactory() {
        this(null, null);
    }

    public MuleBasedAnypointMqClientFactory(HttpClient httpClient, Scheduler scheduler) {
        this.httpClient = httpClient;
        this.scheduler = scheduler;
    }

    public AnypointMqClient createClient(String courierApiUrl, CourierAuthenticationCredentials authenticationCredentials) {
        Preconditions.checkArgument(authenticationCredentials instanceof OAuthCredentials);
        return new DefaultAnypointMqClient(new AsyncMuleCourierRestClient(courierApiUrl, OAuthCredentials.class.cast(authenticationCredentials), httpClient, scheduler));
    }
}
