package com.mulesoft.extension.mq.internal.config;

import static com.mulesoft.extension.mq.internal.config.MQPrefetchConfiguration.PREFETCH;

import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

import com.mulesoft.extension.mq.internal.connection.AnypointMQConnectionProvider;
import com.mulesoft.extension.mq.internal.operation.AnypointMQOperations;
import com.mulesoft.extension.mq.internal.source.AnypointMQSource;

@Configuration(name = "default-subscriber")
@Operations(AnypointMQOperations.class)
@Sources(AnypointMQSource.class)
@ConnectionProviders(AnypointMQConnectionProvider.class)
public class AnypointMQConfiguration implements SubscriberConfiguration {

    private static final String BASIC_SETTINGS = "Basic Settings";

    @ParameterGroup(name = BASIC_SETTINGS)
    private BasicSettingsParameterGroup basicSettings;

    @ParameterGroup(name = "Prefetch Configuration")
    @Placement(tab = PREFETCH)
    private MQPrefetchConfiguration prefetch;

    @Override
    public SubscriberAckMode getAcknowledgementMode() {
        return basicSettings.getAcknowledgementMode();
    }

    @Override
    public Long getAcknowledgementTimeout() {
        return basicSettings.getAcknowledgementTimeout();
    }

    @Override
    public Long getPollingTime() {
        return basicSettings.getPollingTime();
    }

    @Override
    public MQPrefetchConfiguration getPrefetch() {
        return prefetch;
    }

    @Override
    public Integer getMaxRedelivery() {
        return basicSettings.getMaxRedelivery();
    }

}
