package com.mulesoft.extension.mq.internal.config;

import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

import com.mulesoft.extension.mq.internal.AbstractSubscriber;

public class BasicSettingsParameterGroup {

    /**
     * The Acknowledgement mode to use for the messages retrieved by the subscribers.
     * This will affect only the subscriber sources and is unrelated to the {@code consume} operation.
     *
     * Please refer to the {@link SubscriberAckMode} for more details on each strategy.
     *
     * @see SubscriberAckMode
     */
    @Parameter
    @Optional(defaultValue = "AUTO")
    @Summary("The Acknowledgement mode to use for the messages retrieved by the subscribers")
    private SubscriberAckMode acknowledgementMode;

    /**
     * States the duration that a message is held by a broker waiting for an Acknowledgement or Not
     * Acknowledgement. If neither an ACK or a NACK occurs before the timeout is exceeded, then the message will be automatically returned
     * to the destination by the broker, making it again available to any subscriber for redelivery.
     *
     * By default, this timeout will be decided by the Subscriber depending on which strategy is used.
     * When doing Polling, then the ACK timeout will be the one configured in the Queue.
     *
     * In the case of using the Prefetch strategy, messages will be kept in a local buffer until they are dispatched to the flow,
     * thus updating the TTL to avoid them be evicted. By default, the messages will be fetched with a TTL of at least 2 minutes.
     */
    @Parameter
    @Optional(defaultValue = "0")
    @Summary("How long should the Broker wait for an ACK or a NACK before redelivering the message. This behavior changes when using prefetch.")
    private long acknowledgementTimeout;

    /**
     * When {@code prefetch} is disabled, this polling time will define how often should the subscriber check for new messages.
     * By default, this will check for messages every one second (only if the prefetch is disabled).
     *
     * The value of this parameter will be considered in MILLISECONDS.
     */
    @Parameter
    @Optional(defaultValue = AbstractSubscriber.DEFAULT_POLLING_TIME_STRING)
    private long pollingTime;

    /**
     * Number of redeliveries to accept for any given message. When the message redelivery count is higher than this threshold,
     * then the message will be ignored by the subscriber and not dispatched to the flow.
     *
     * In order for the message to be removed from the queue, the Queue should be configured with a DLQ from the admin console.
     *
     * To avoid a poison message, the default value is set to -1 (infinite).
     */
    @Parameter
    @Optional(defaultValue = "-1")
    private int maxRedelivery;

    public SubscriberAckMode getAcknowledgementMode() {
        return acknowledgementMode;
    }

    public Long getAcknowledgementTimeout() {
        return acknowledgementTimeout;
    }

    public Long getPollingTime() {
        return pollingTime;
    }

    public int getMaxRedelivery() {
        return maxRedelivery;
    }
}
