/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package com.mulesoft.extension.mq.internal.config;

/**
 * When a message is received, it can be consumed based on different strategies.
 */
public enum ConsumerAckMode {
    /**
     * The message will be consumed once the message is received
     */
    IMMEDIATE,
    /**
     * The client that receives the message needs to explicitly acknowledge that the message must be
     * consumed
     */
    MANUAL
}
