package com.mulesoft.extension.mq.internal.config;

import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

/**
 */
@Alias("prefetch")
public class MQPrefetchConfiguration {

    public static final String PREFETCH = "Prefetch";

    /**
     * Max number of messages to receive on each request. The response can contain fewer
     * messages than this number depending on the load of the target Queue.
     * This number will also affect the local buffer of the prefetched messages.
     *
     * Setting this {@code fetchSize} to zero will disable the message prefetch.
     *
     * The prefetch buffer will have a target size of three times the {@code fetchSize},
     * meaning that requests to retrieve messages will continue as long as the local buffer
     * is not full.
     * Only in the case of a slow consumer, where Mule's Runtime has no more threads available
     * to process the request, is the buffer limit going to be reached.
     *
     * Enable prefetch for maximum throughput, in cases where high performance on message delivery is required.
     * In cases where controlled message retrieval is required, please disable prefetch and use the fixed polling
     * configuration.
     *
     * By default this will try to fetch the max number of 10 messages per request.
     */
    @Parameter
    @Optional(defaultValue = "10")
    @Placement(tab = PREFETCH)
    @Summary("Max number of messages to receive on each request. To disable prefetch set this value to zero.")
    private int fetchSize;

    /**
     * Maximum duration in milliseconds to wait for the required amount of messages. If this
     * duration elapses, the response is sent with as many messages as received during the period.
     */
    @Parameter
    @Optional(defaultValue = "1000")
    @Placement(tab = PREFETCH)
    private long fetchTimeout;

    /**
     * Fixed frequency in milliseconds at which the retrieval of messages will be attempted when
     * there are no more messages to process locally.
     *
     * In the case were a Queue is empty and all the messages retrieved were already processes,
     * this frequency will define how long to wait before attempting to retrieve more messages.
     *
     * By default, this frequency is 5 seconds.
     */
    @Parameter
    @Optional(defaultValue = "5000")
    @Placement(tab = PREFETCH)
    @Summary("Frequency in milliseconds at which the retrieval of messages will be attempted when there are no more messages to process")
    private long frequency;

    public int getFetchSize() {
        return fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public long getFetchTimeout() {
        return fetchTimeout;
    }

    public void setFetchTimeout(long fetchTimeout) {
        this.fetchTimeout = fetchTimeout;
    }

    public long getFrequency() {
        return frequency;
    }

    public void setFrequency(long frequency) {
        this.frequency = frequency;
    }
}
