/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package com.mulesoft.extension.mq.internal.config;

/**
 * Defines the behavior of the Anypoint MQ Subscriber regarding the acknowledgement of the messages retrieved.
 */
public enum SubscriberAckMode {

    /**
     * The message will be ACKed as soon as it is dispatched to the flow.
     * If the processing of the message fails during the execution of the flow,
     * it has to be handled by the application.
     */
    IMMEDIATE,

    /**
     * The message will be ACKed only if the flow that processes it finishes successfully.
     * If an error is propagated during the execution of the flow, finalizing the execution with an error,
     * then the subscriber listener will NACK the message, effectively returning it to the destination for redelivery.
     * In case the flow processing is not completed before the acknowledgement TTL is evicted,
     * then the message will be returned automatically to the destination by the broker for its redelivery.
     */
    AUTO,

    /**
     * The subscriber will not handle any aspect of the acknowledgement of the message. Once it is dispatched to the flow,
     * for processing, the application is in charge of performing either an ACK or a NACK.
     * If none is performed before the acknowledgement TTL is evicted, then the message will be returned automatically
     * to the destination by the broker for its redelivery.
     */
    MANUAL;

}
