package com.mulesoft.extension.mq.internal.connection;

import com.mulesoft.extension.mq.internal.DefaultMessageContextFactory;
import com.mulesoft.extension.mq.internal.client.MuleBasedAnypointMqClientFactory;
import com.mulesoft.mq.restclient.api.AnypointMqClient;
import com.mulesoft.mq.restclient.api.Destination;
import com.mulesoft.mq.restclient.impl.OAuthCredentials;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;

public class AnypointMQConnection {
    private DefaultMessageContextFactory messageContextFactory = new DefaultMessageContextFactory();
    private final AnypointMqClient client;
    private Scheduler ioScheduler;
    private HttpClient httpClient;
    public AnypointMQConnection(HttpClient httpClient, String url, String clientId, String clientSecret, Scheduler scheduler) {
        this.ioScheduler = scheduler;
        this.httpClient = httpClient;
        httpClient.start();
        //TODO MQ-533 - DONE - Migrate to Mule based Rest Client
        client = new MuleBasedAnypointMqClientFactory(httpClient, scheduler).createClient(url, new OAuthCredentials(clientId, clientSecret));
        //TODO MQ-547 - The possible exception thrown in the init() method should be handled
        client.init();
    }

    public void validate() {
        // FIXME: Make this method validate the connection.
    }

    public void disconnect() {
        client.dispose();
        ioScheduler.stop();
        httpClient.stop();
    }

    public Destination getDestination(String destination) {
        return client.createDestinationLocator()
                .getDestination(client.createDestinationLocator()
                        .getDefaultDestinationLocation(destination)).getValue();
    }

    public DefaultMessageContextFactory getMessageContextFactory() {
        return messageContextFactory;
    }
}
