package com.mulesoft.extension.mq.internal.connection;

import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;

public class ProxyParameterGroup {

    @Parameter
    @Optional
    private String host;
    @Parameter
    @Optional
    private int port;
    @Parameter
    @Optional
    private String username;
    @Parameter
    @Optional
    private String password;

    public ProxyConfig toProxyConfig() {
        return host != null && port != 0 ? ProxyConfig.builder()
                .host(host)
                .port(port)
                .username(username)
                .password(password)
                .build() : null;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}
