package com.mulesoft.extension.mq.internal.error;

import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;

import java.util.Optional;

import static java.util.Optional.ofNullable;

/**
 * Created by martinp on 14/09/17.
 */
public enum AnypointMQError implements ErrorTypeDefinition<AnypointMQError> {
    CONNECTIVITY(MuleErrors.CONNECTIVITY),
    RESOURCE_NOT_FOUND(CONNECTIVITY),
    UNKNOWN(CONNECTIVITY);

    private ErrorTypeDefinition<?> parentErrorType;

    AnypointMQError(final ErrorTypeDefinition parentErrorType) {
        this.parentErrorType = parentErrorType;
    }

    @Override
    public Optional<ErrorTypeDefinition<? extends Enum<?>>> getParent() {
        return ofNullable(parentErrorType);
    }

}
