package com.mulesoft.extension.mq.internal.exception;

import com.mulesoft.mq.restclient.api.exception.ResourceNotFoundException;

import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandler;

import static com.mulesoft.extension.mq.internal.error.AnypointMQError.RESOURCE_NOT_FOUND;
import static com.mulesoft.extension.mq.internal.error.AnypointMQError.UNKNOWN;

//TODO MQ-547 - Improve to detect Connection Exception to be able to handle connection reconnections
public class AnypointMQExceptionHandler extends ExceptionHandler {
    @Override
    public Exception enrichException(Exception e) {
        if (e instanceof ResourceNotFoundException) {
            return new ModuleException(RESOURCE_NOT_FOUND, e);
        }
        return new ModuleException(UNKNOWN, e);
    }
}
